/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation based on the percentile of values in a dimension or measure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PercentileAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<PercentileAggregation.Builder, PercentileAggregation> {
    private static final SdkField<Double> PERCENTILE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("PercentileValue").getter(getter(PercentileAggregation::percentileValue))
            .setter(setter(Builder::percentileValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentileValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTILE_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double percentileValue;

    private PercentileAggregation(BuilderImpl builder) {
        this.percentileValue = builder.percentileValue;
    }

    /**
     * <p>
     * The percentile value. This value can be any numeric constant 0–100. A percentile value of 50 computes the median
     * value of the measure.
     * </p>
     * 
     * @return The percentile value. This value can be any numeric constant 0–100. A percentile value of 50 computes the
     *         median value of the measure.
     */
    public final Double percentileValue() {
        return percentileValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(percentileValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PercentileAggregation)) {
            return false;
        }
        PercentileAggregation other = (PercentileAggregation) obj;
        return Objects.equals(percentileValue(), other.percentileValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PercentileAggregation").add("PercentileValue", percentileValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentileValue":
            return Optional.ofNullable(clazz.cast(percentileValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PercentileValue", PERCENTILE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PercentileAggregation, T> g) {
        return obj -> g.apply((PercentileAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PercentileAggregation> {
        /**
         * <p>
         * The percentile value. This value can be any numeric constant 0–100. A percentile value of 50 computes the
         * median value of the measure.
         * </p>
         * 
         * @param percentileValue
         *        The percentile value. This value can be any numeric constant 0–100. A percentile value of 50 computes
         *        the median value of the measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentileValue(Double percentileValue);
    }

    static final class BuilderImpl implements Builder {
        private Double percentileValue;

        private BuilderImpl() {
        }

        private BuilderImpl(PercentileAggregation model) {
            percentileValue(model.percentileValue);
        }

        public final Double getPercentileValue() {
            return percentileValue;
        }

        public final void setPercentileValue(Double percentileValue) {
            this.percentileValue = percentileValue;
        }

        @Override
        public final Builder percentileValue(Double percentileValue) {
            this.percentileValue = percentileValue;
            return this;
        }

        @Override
        public PercentileAggregation build() {
            return new PercentileAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
