/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreAnalysisResponse extends QuickSightResponse implements
        ToCopyableBuilder<RestoreAnalysisResponse.Builder, RestoreAnalysisResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(RestoreAnalysisResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RestoreAnalysisResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnalysisId").getter(getter(RestoreAnalysisResponse::analysisId)).setter(setter(Builder::analysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(RestoreAnalysisResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<List<String>> RESTORATION_FAILED_FOLDER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RestorationFailedFolderArns")
            .getter(getter(RestoreAnalysisResponse::restorationFailedFolderArns))
            .setter(setter(Builder::restorationFailedFolderArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorationFailedFolderArns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD,
            ANALYSIS_ID_FIELD, REQUEST_ID_FIELD, RESTORATION_FAILED_FOLDER_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer status;

    private final String arn;

    private final String analysisId;

    private final String requestId;

    private final List<String> restorationFailedFolderArns;

    private RestoreAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.requestId = builder.requestId;
        this.restorationFailedFolderArns = builder.restorationFailedFolderArns;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the analysis that you're restoring.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the analysis that you're restoring.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the analysis that you're restoring.
     * </p>
     * 
     * @return The ID of the analysis that you're restoring.
     */
    public final String analysisId() {
        return analysisId;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestorationFailedFolderArns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestorationFailedFolderArns() {
        return restorationFailedFolderArns != null && !(restorationFailedFolderArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of folder arns thatthe analysis failed to be restored to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestorationFailedFolderArns} method.
     * </p>
     * 
     * @return A list of folder arns thatthe analysis failed to be restored to.
     */
    public final List<String> restorationFailedFolderArns() {
        return restorationFailedFolderArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestorationFailedFolderArns() ? restorationFailedFolderArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreAnalysisResponse)) {
            return false;
        }
        RestoreAnalysisResponse other = (RestoreAnalysisResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(arn(), other.arn())
                && Objects.equals(analysisId(), other.analysisId()) && Objects.equals(requestId(), other.requestId())
                && hasRestorationFailedFolderArns() == other.hasRestorationFailedFolderArns()
                && Objects.equals(restorationFailedFolderArns(), other.restorationFailedFolderArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreAnalysisResponse").add("Status", status()).add("Arn", arn())
                .add("AnalysisId", analysisId()).add("RequestId", requestId())
                .add("RestorationFailedFolderArns", hasRestorationFailedFolderArns() ? restorationFailedFolderArns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AnalysisId":
            return Optional.ofNullable(clazz.cast(analysisId()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "RestorationFailedFolderArns":
            return Optional.ofNullable(clazz.cast(restorationFailedFolderArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("AnalysisId", ANALYSIS_ID_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("RestorationFailedFolderArns", RESTORATION_FAILED_FOLDER_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreAnalysisResponse, T> g) {
        return obj -> g.apply((RestoreAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, RestoreAnalysisResponse> {
        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the analysis that you're restoring.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the analysis that you're restoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the analysis that you're restoring.
         * </p>
         * 
         * @param analysisId
         *        The ID of the analysis that you're restoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisId(String analysisId);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * A list of folder arns thatthe analysis failed to be restored to.
         * </p>
         * 
         * @param restorationFailedFolderArns
         *        A list of folder arns thatthe analysis failed to be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorationFailedFolderArns(Collection<String> restorationFailedFolderArns);

        /**
         * <p>
         * A list of folder arns thatthe analysis failed to be restored to.
         * </p>
         * 
         * @param restorationFailedFolderArns
         *        A list of folder arns thatthe analysis failed to be restored to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restorationFailedFolderArns(String... restorationFailedFolderArns);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private String arn;

        private String analysisId;

        private String requestId;

        private List<String> restorationFailedFolderArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreAnalysisResponse model) {
            super(model);
            status(model.status);
            arn(model.arn);
            analysisId(model.analysisId);
            requestId(model.requestId);
            restorationFailedFolderArns(model.restorationFailedFolderArns);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAnalysisId() {
            return analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Collection<String> getRestorationFailedFolderArns() {
            if (restorationFailedFolderArns instanceof SdkAutoConstructList) {
                return null;
            }
            return restorationFailedFolderArns;
        }

        public final void setRestorationFailedFolderArns(Collection<String> restorationFailedFolderArns) {
            this.restorationFailedFolderArns = FolderArnListCopier.copy(restorationFailedFolderArns);
        }

        @Override
        public final Builder restorationFailedFolderArns(Collection<String> restorationFailedFolderArns) {
            this.restorationFailedFolderArns = FolderArnListCopier.copy(restorationFailedFolderArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorationFailedFolderArns(String... restorationFailedFolderArns) {
            restorationFailedFolderArns(Arrays.asList(restorationFailedFolderArns));
            return this;
        }

        @Override
        public RestoreAnalysisResponse build() {
            return new RestoreAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
