/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An image that is located on a sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetImage implements SdkPojo, Serializable, ToCopyableBuilder<SheetImage.Builder, SheetImage> {
    private static final SdkField<String> SHEET_IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetImageId").getter(getter(SheetImage::sheetImageId)).setter(setter(Builder::sheetImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetImageId").build()).build();

    private static final SdkField<SheetImageSource> SOURCE_FIELD = SdkField.<SheetImageSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(SheetImage::source)).setter(setter(Builder::source))
            .constructor(SheetImageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<SheetImageScalingConfiguration> SCALING_FIELD = SdkField
            .<SheetImageScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Scaling")
            .getter(getter(SheetImage::scaling)).setter(setter(Builder::scaling))
            .constructor(SheetImageScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scaling").build()).build();

    private static final SdkField<SheetImageTooltipConfiguration> TOOLTIP_FIELD = SdkField
            .<SheetImageTooltipConfiguration> builder(MarshallingType.SDK_POJO).memberName("Tooltip")
            .getter(getter(SheetImage::tooltip)).setter(setter(Builder::tooltip))
            .constructor(SheetImageTooltipConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<String> IMAGE_CONTENT_ALT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageContentAltText").getter(getter(SheetImage::imageContentAltText))
            .setter(setter(Builder::imageContentAltText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageContentAltText").build())
            .build();

    private static final SdkField<ImageInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<ImageInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(SheetImage::interactions)).setter(setter(Builder::interactions))
            .constructor(ImageInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final SdkField<List<ImageCustomAction>> ACTIONS_FIELD = SdkField
            .<List<ImageCustomAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(SheetImage::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageCustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageCustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_IMAGE_ID_FIELD,
            SOURCE_FIELD, SCALING_FIELD, TOOLTIP_FIELD, IMAGE_CONTENT_ALT_TEXT_FIELD, INTERACTIONS_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sheetImageId;

    private final SheetImageSource source;

    private final SheetImageScalingConfiguration scaling;

    private final SheetImageTooltipConfiguration tooltip;

    private final String imageContentAltText;

    private final ImageInteractionOptions interactions;

    private final List<ImageCustomAction> actions;

    private SheetImage(BuilderImpl builder) {
        this.sheetImageId = builder.sheetImageId;
        this.source = builder.source;
        this.scaling = builder.scaling;
        this.tooltip = builder.tooltip;
        this.imageContentAltText = builder.imageContentAltText;
        this.interactions = builder.interactions;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The ID of the sheet image.
     * </p>
     * 
     * @return The ID of the sheet image.
     */
    public final String sheetImageId() {
        return sheetImageId;
    }

    /**
     * <p>
     * The source of the image.
     * </p>
     * 
     * @return The source of the image.
     */
    public final SheetImageSource source() {
        return source;
    }

    /**
     * <p>
     * Determines how the image is scaled.
     * </p>
     * 
     * @return Determines how the image is scaled.
     */
    public final SheetImageScalingConfiguration scaling() {
        return scaling;
    }

    /**
     * <p>
     * The tooltip to be shown when hovering over the image.
     * </p>
     * 
     * @return The tooltip to be shown when hovering over the image.
     */
    public final SheetImageTooltipConfiguration tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The alt text for the image.
     * </p>
     * 
     * @return The alt text for the image.
     */
    public final String imageContentAltText() {
        return imageContentAltText;
    }

    /**
     * <p>
     * The general image interactions setup for an image.
     * </p>
     * 
     * @return The general image interactions setup for an image.
     */
    public final ImageInteractionOptions interactions() {
        return interactions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom actions that are configured for an image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of custom actions that are configured for an image.
     */
    public final List<ImageCustomAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetImageId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(scaling());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(imageContentAltText());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImage)) {
            return false;
        }
        SheetImage other = (SheetImage) obj;
        return Objects.equals(sheetImageId(), other.sheetImageId()) && Objects.equals(source(), other.source())
                && Objects.equals(scaling(), other.scaling()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(imageContentAltText(), other.imageContentAltText())
                && Objects.equals(interactions(), other.interactions()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetImage").add("SheetImageId", sheetImageId()).add("Source", source())
                .add("Scaling", scaling()).add("Tooltip", tooltip()).add("ImageContentAltText", imageContentAltText())
                .add("Interactions", interactions()).add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetImageId":
            return Optional.ofNullable(clazz.cast(sheetImageId()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Scaling":
            return Optional.ofNullable(clazz.cast(scaling()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "ImageContentAltText":
            return Optional.ofNullable(clazz.cast(imageContentAltText()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetImageId", SHEET_IMAGE_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Scaling", SCALING_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ImageContentAltText", IMAGE_CONTENT_ALT_TEXT_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImage, T> g) {
        return obj -> g.apply((SheetImage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetImage> {
        /**
         * <p>
         * The ID of the sheet image.
         * </p>
         * 
         * @param sheetImageId
         *        The ID of the sheet image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetImageId(String sheetImageId);

        /**
         * <p>
         * The source of the image.
         * </p>
         * 
         * @param source
         *        The source of the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(SheetImageSource source);

        /**
         * <p>
         * The source of the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetImageSource.Builder} avoiding the
         * need to create one manually via {@link SheetImageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetImageSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(SheetImageSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link SheetImageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(SheetImageSource)
         */
        default Builder source(Consumer<SheetImageSource.Builder> source) {
            return source(SheetImageSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Determines how the image is scaled.
         * </p>
         * 
         * @param scaling
         *        Determines how the image is scaled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaling(SheetImageScalingConfiguration scaling);

        /**
         * <p>
         * Determines how the image is scaled.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetImageScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link SheetImageScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetImageScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scaling(SheetImageScalingConfiguration)}.
         * 
         * @param scaling
         *        a consumer that will call methods on {@link SheetImageScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scaling(SheetImageScalingConfiguration)
         */
        default Builder scaling(Consumer<SheetImageScalingConfiguration.Builder> scaling) {
            return scaling(SheetImageScalingConfiguration.builder().applyMutation(scaling).build());
        }

        /**
         * <p>
         * The tooltip to be shown when hovering over the image.
         * </p>
         * 
         * @param tooltip
         *        The tooltip to be shown when hovering over the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(SheetImageTooltipConfiguration tooltip);

        /**
         * <p>
         * The tooltip to be shown when hovering over the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetImageTooltipConfiguration.Builder}
         * avoiding the need to create one manually via {@link SheetImageTooltipConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetImageTooltipConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #tooltip(SheetImageTooltipConfiguration)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link SheetImageTooltipConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(SheetImageTooltipConfiguration)
         */
        default Builder tooltip(Consumer<SheetImageTooltipConfiguration.Builder> tooltip) {
            return tooltip(SheetImageTooltipConfiguration.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The alt text for the image.
         * </p>
         * 
         * @param imageContentAltText
         *        The alt text for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageContentAltText(String imageContentAltText);

        /**
         * <p>
         * The general image interactions setup for an image.
         * </p>
         * 
         * @param interactions
         *        The general image interactions setup for an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(ImageInteractionOptions interactions);

        /**
         * <p>
         * The general image interactions setup for an image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageInteractionOptions.Builder} avoiding
         * the need to create one manually via {@link ImageInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(ImageInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link ImageInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(ImageInteractionOptions)
         */
        default Builder interactions(Consumer<ImageInteractionOptions.Builder> interactions) {
            return interactions(ImageInteractionOptions.builder().applyMutation(interactions).build());
        }

        /**
         * <p>
         * A list of custom actions that are configured for an image.
         * </p>
         * 
         * @param actions
         *        A list of custom actions that are configured for an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<ImageCustomAction> actions);

        /**
         * <p>
         * A list of custom actions that are configured for an image.
         * </p>
         * 
         * @param actions
         *        A list of custom actions that are configured for an image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ImageCustomAction... actions);

        /**
         * <p>
         * A list of custom actions that are configured for an image.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ImageCustomAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ImageCustomAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ImageCustomAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<ImageCustomAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ImageCustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<ImageCustomAction>)
         */
        Builder actions(Consumer<ImageCustomAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String sheetImageId;

        private SheetImageSource source;

        private SheetImageScalingConfiguration scaling;

        private SheetImageTooltipConfiguration tooltip;

        private String imageContentAltText;

        private ImageInteractionOptions interactions;

        private List<ImageCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImage model) {
            sheetImageId(model.sheetImageId);
            source(model.source);
            scaling(model.scaling);
            tooltip(model.tooltip);
            imageContentAltText(model.imageContentAltText);
            interactions(model.interactions);
            actions(model.actions);
        }

        public final String getSheetImageId() {
            return sheetImageId;
        }

        public final void setSheetImageId(String sheetImageId) {
            this.sheetImageId = sheetImageId;
        }

        @Override
        public final Builder sheetImageId(String sheetImageId) {
            this.sheetImageId = sheetImageId;
            return this;
        }

        public final SheetImageSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(SheetImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(SheetImageSource source) {
            this.source = source;
            return this;
        }

        public final SheetImageScalingConfiguration.Builder getScaling() {
            return scaling != null ? scaling.toBuilder() : null;
        }

        public final void setScaling(SheetImageScalingConfiguration.BuilderImpl scaling) {
            this.scaling = scaling != null ? scaling.build() : null;
        }

        @Override
        public final Builder scaling(SheetImageScalingConfiguration scaling) {
            this.scaling = scaling;
            return this;
        }

        public final SheetImageTooltipConfiguration.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(SheetImageTooltipConfiguration.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(SheetImageTooltipConfiguration tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final String getImageContentAltText() {
            return imageContentAltText;
        }

        public final void setImageContentAltText(String imageContentAltText) {
            this.imageContentAltText = imageContentAltText;
        }

        @Override
        public final Builder imageContentAltText(String imageContentAltText) {
            this.imageContentAltText = imageContentAltText;
            return this;
        }

        public final ImageInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(ImageInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(ImageInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public final List<ImageCustomAction.Builder> getActions() {
            List<ImageCustomAction.Builder> result = ImageCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ImageCustomAction.BuilderImpl> actions) {
            this.actions = ImageCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ImageCustomAction> actions) {
            this.actions = ImageCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ImageCustomAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ImageCustomAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> ImageCustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SheetImage build() {
            return new SheetImage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
