/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the properties of a chart's axes that are used by small multiples panels.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmallMultiplesAxisProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SmallMultiplesAxisProperties.Builder, SmallMultiplesAxisProperties> {
    private static final SdkField<String> SCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scale")
            .getter(getter(SmallMultiplesAxisProperties::scaleAsString)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()).build();

    private static final SdkField<String> PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Placement").getter(getter(SmallMultiplesAxisProperties::placementAsString))
            .setter(setter(Builder::placement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_FIELD, PLACEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scale;

    private final String placement;

    private SmallMultiplesAxisProperties(BuilderImpl builder) {
        this.scale = builder.scale;
        this.placement = builder.placement;
    }

    /**
     * <p>
     * Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scale} will return
     * {@link SmallMultiplesAxisScale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scaleAsString}.
     * </p>
     * 
     * @return Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
     * @see SmallMultiplesAxisScale
     */
    public final SmallMultiplesAxisScale scale() {
        return SmallMultiplesAxisScale.fromValue(scale);
    }

    /**
     * <p>
     * Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scale} will return
     * {@link SmallMultiplesAxisScale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scaleAsString}.
     * </p>
     * 
     * @return Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
     * @see SmallMultiplesAxisScale
     */
    public final String scaleAsString() {
        return scale;
    }

    /**
     * <p>
     * Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes with
     * <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link SmallMultiplesAxisPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #placementAsString}.
     * </p>
     * 
     * @return Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes
     *         with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
     * @see SmallMultiplesAxisPlacement
     */
    public final SmallMultiplesAxisPlacement placement() {
        return SmallMultiplesAxisPlacement.fromValue(placement);
    }

    /**
     * <p>
     * Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes with
     * <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #placement} will
     * return {@link SmallMultiplesAxisPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #placementAsString}.
     * </p>
     * 
     * @return Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes
     *         with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
     * @see SmallMultiplesAxisPlacement
     */
    public final String placementAsString() {
        return placement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(placementAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmallMultiplesAxisProperties)) {
            return false;
        }
        SmallMultiplesAxisProperties other = (SmallMultiplesAxisProperties) obj;
        return Objects.equals(scaleAsString(), other.scaleAsString())
                && Objects.equals(placementAsString(), other.placementAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmallMultiplesAxisProperties").add("Scale", scaleAsString())
                .add("Placement", placementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scale":
            return Optional.ofNullable(clazz.cast(scaleAsString()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placementAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Scale", SCALE_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmallMultiplesAxisProperties, T> g) {
        return obj -> g.apply((SmallMultiplesAxisProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmallMultiplesAxisProperties> {
        /**
         * <p>
         * Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
         * </p>
         * 
         * @param scale
         *        Determines whether scale of the axes are shared or independent. The default value is
         *        <code>SHARED</code>.
         * @see SmallMultiplesAxisScale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmallMultiplesAxisScale
         */
        Builder scale(String scale);

        /**
         * <p>
         * Determines whether scale of the axes are shared or independent. The default value is <code>SHARED</code>.
         * </p>
         * 
         * @param scale
         *        Determines whether scale of the axes are shared or independent. The default value is
         *        <code>SHARED</code>.
         * @see SmallMultiplesAxisScale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmallMultiplesAxisScale
         */
        Builder scale(SmallMultiplesAxisScale scale);

        /**
         * <p>
         * Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes
         * with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
         * </p>
         * 
         * @param placement
         *        Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels.
         *        Axes with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
         * @see SmallMultiplesAxisPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmallMultiplesAxisPlacement
         */
        Builder placement(String placement);

        /**
         * <p>
         * Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels. Axes
         * with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
         * </p>
         * 
         * @param placement
         *        Defines the placement of the axis. By default, axes are rendered <code>OUTSIDE</code> of the panels.
         *        Axes with <code>INDEPENDENT</code> scale are rendered <code>INSIDE</code> the panels.
         * @see SmallMultiplesAxisPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SmallMultiplesAxisPlacement
         */
        Builder placement(SmallMultiplesAxisPlacement placement);
    }

    static final class BuilderImpl implements Builder {
        private String scale;

        private String placement;

        private BuilderImpl() {
        }

        private BuilderImpl(SmallMultiplesAxisProperties model) {
            scale(model.scale);
            placement(model.placement);
        }

        public final String getScale() {
            return scale;
        }

        public final void setScale(String scale) {
            this.scale = scale;
        }

        @Override
        public final Builder scale(String scale) {
            this.scale = scale;
            return this;
        }

        @Override
        public final Builder scale(SmallMultiplesAxisScale scale) {
            this.scale(scale == null ? null : scale.toString());
            return this;
        }

        public final String getPlacement() {
            return placement;
        }

        public final void setPlacement(String placement) {
            this.placement = placement;
        }

        @Override
        public final Builder placement(String placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public final Builder placement(SmallMultiplesAxisPlacement placement) {
            this.placement(placement == null ? null : placement.toString());
            return this;
        }

        @Override
        public SmallMultiplesAxisProperties build() {
            return new SmallMultiplesAxisProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
