/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the information for the snapshot that you want to generate. This information is provided by
 * you when you start a new snapshot job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotFile implements SdkPojo, Serializable, ToCopyableBuilder<SnapshotFile.Builder, SnapshotFile> {
    private static final SdkField<List<SnapshotFileSheetSelection>> SHEET_SELECTIONS_FIELD = SdkField
            .<List<SnapshotFileSheetSelection>> builder(MarshallingType.LIST)
            .memberName("SheetSelections")
            .getter(getter(SnapshotFile::sheetSelections))
            .setter(setter(Builder::sheetSelections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetSelections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotFileSheetSelection> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotFileSheetSelection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FormatType").getter(getter(SnapshotFile::formatTypeAsString)).setter(setter(Builder::formatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_SELECTIONS_FIELD,
            FORMAT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SnapshotFileSheetSelection> sheetSelections;

    private final String formatType;

    private SnapshotFile(BuilderImpl builder) {
        this.sheetSelections = builder.sheetSelections;
        this.formatType = builder.formatType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SheetSelections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSheetSelections() {
        return sheetSelections != null && !(sheetSelections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet that is
     * exported. These objects provide information about the snapshot artifacts that are generated during the job. This
     * structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1 configuration for PDF.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSheetSelections} method.
     * </p>
     * 
     * @return A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet
     *         that is exported. These objects provide information about the snapshot artifacts that are generated
     *         during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1
     *         configuration for PDF.
     */
    public final List<SnapshotFileSheetSelection> sheetSelections() {
        return sheetSelections;
    }

    /**
     * <p>
     * The format of the snapshot file to be generated. You can choose between <code>CSV</code>, <code>Excel</code>, or
     * <code>PDF</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link SnapshotFileFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatTypeAsString}.
     * </p>
     * 
     * @return The format of the snapshot file to be generated. You can choose between <code>CSV</code>,
     *         <code>Excel</code>, or <code>PDF</code>.
     * @see SnapshotFileFormatType
     */
    public final SnapshotFileFormatType formatType() {
        return SnapshotFileFormatType.fromValue(formatType);
    }

    /**
     * <p>
     * The format of the snapshot file to be generated. You can choose between <code>CSV</code>, <code>Excel</code>, or
     * <code>PDF</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatType} will
     * return {@link SnapshotFileFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatTypeAsString}.
     * </p>
     * 
     * @return The format of the snapshot file to be generated. You can choose between <code>CSV</code>,
     *         <code>Excel</code>, or <code>PDF</code>.
     * @see SnapshotFileFormatType
     */
    public final String formatTypeAsString() {
        return formatType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSheetSelections() ? sheetSelections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(formatTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFile)) {
            return false;
        }
        SnapshotFile other = (SnapshotFile) obj;
        return hasSheetSelections() == other.hasSheetSelections() && Objects.equals(sheetSelections(), other.sheetSelections())
                && Objects.equals(formatTypeAsString(), other.formatTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotFile").add("SheetSelections", hasSheetSelections() ? sheetSelections() : null)
                .add("FormatType", formatTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetSelections":
            return Optional.ofNullable(clazz.cast(sheetSelections()));
        case "FormatType":
            return Optional.ofNullable(clazz.cast(formatTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetSelections", SHEET_SELECTIONS_FIELD);
        map.put("FormatType", FORMAT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotFile, T> g) {
        return obj -> g.apply((SnapshotFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotFile> {
        /**
         * <p>
         * A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet
         * that is exported. These objects provide information about the snapshot artifacts that are generated during
         * the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1
         * configuration for PDF.
         * </p>
         * 
         * @param sheetSelections
         *        A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard
         *        sheet that is exported. These objects provide information about the snapshot artifacts that are
         *        generated during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel
         *        configurations, or 1 configuration for PDF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetSelections(Collection<SnapshotFileSheetSelection> sheetSelections);

        /**
         * <p>
         * A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet
         * that is exported. These objects provide information about the snapshot artifacts that are generated during
         * the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1
         * configuration for PDF.
         * </p>
         * 
         * @param sheetSelections
         *        A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard
         *        sheet that is exported. These objects provide information about the snapshot artifacts that are
         *        generated during the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel
         *        configurations, or 1 configuration for PDF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetSelections(SnapshotFileSheetSelection... sheetSelections);

        /**
         * <p>
         * A list of <code>SnapshotFileSheetSelection</code> objects that contain information on the dashboard sheet
         * that is exported. These objects provide information about the snapshot artifacts that are generated during
         * the job. This structure can hold a maximum of 5 CSV configurations, 5 Excel configurations, or 1
         * configuration for PDF.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelection.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #sheetSelections(List<SnapshotFileSheetSelection>)}.
         * 
         * @param sheetSelections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetSelections(java.util.Collection<SnapshotFileSheetSelection>)
         */
        Builder sheetSelections(Consumer<SnapshotFileSheetSelection.Builder>... sheetSelections);

        /**
         * <p>
         * The format of the snapshot file to be generated. You can choose between <code>CSV</code>, <code>Excel</code>,
         * or <code>PDF</code>.
         * </p>
         * 
         * @param formatType
         *        The format of the snapshot file to be generated. You can choose between <code>CSV</code>,
         *        <code>Excel</code>, or <code>PDF</code>.
         * @see SnapshotFileFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotFileFormatType
         */
        Builder formatType(String formatType);

        /**
         * <p>
         * The format of the snapshot file to be generated. You can choose between <code>CSV</code>, <code>Excel</code>,
         * or <code>PDF</code>.
         * </p>
         * 
         * @param formatType
         *        The format of the snapshot file to be generated. You can choose between <code>CSV</code>,
         *        <code>Excel</code>, or <code>PDF</code>.
         * @see SnapshotFileFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotFileFormatType
         */
        Builder formatType(SnapshotFileFormatType formatType);
    }

    static final class BuilderImpl implements Builder {
        private List<SnapshotFileSheetSelection> sheetSelections = DefaultSdkAutoConstructList.getInstance();

        private String formatType;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotFile model) {
            sheetSelections(model.sheetSelections);
            formatType(model.formatType);
        }

        public final List<SnapshotFileSheetSelection.Builder> getSheetSelections() {
            List<SnapshotFileSheetSelection.Builder> result = SnapshotFileSheetSelectionListCopier
                    .copyToBuilder(this.sheetSelections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheetSelections(Collection<SnapshotFileSheetSelection.BuilderImpl> sheetSelections) {
            this.sheetSelections = SnapshotFileSheetSelectionListCopier.copyFromBuilder(sheetSelections);
        }

        @Override
        public final Builder sheetSelections(Collection<SnapshotFileSheetSelection> sheetSelections) {
            this.sheetSelections = SnapshotFileSheetSelectionListCopier.copy(sheetSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetSelections(SnapshotFileSheetSelection... sheetSelections) {
            sheetSelections(Arrays.asList(sheetSelections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetSelections(Consumer<SnapshotFileSheetSelection.Builder>... sheetSelections) {
            sheetSelections(Stream.of(sheetSelections).map(c -> SnapshotFileSheetSelection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFormatType() {
            return formatType;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        @Override
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        public final Builder formatType(SnapshotFileFormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        @Override
        public SnapshotFile build() {
            return new SnapshotFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
