/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field wells of a tree map.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TreeMapFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<TreeMapFieldWells.Builder, TreeMapFieldWells> {
    private static final SdkField<TreeMapAggregatedFieldWells> TREE_MAP_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<TreeMapAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("TreeMapAggregatedFieldWells")
            .getter(getter(TreeMapFieldWells::treeMapAggregatedFieldWells))
            .setter(setter(Builder::treeMapAggregatedFieldWells))
            .constructor(TreeMapAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TREE_MAP_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TreeMapAggregatedFieldWells treeMapAggregatedFieldWells;

    private TreeMapFieldWells(BuilderImpl builder) {
        this.treeMapAggregatedFieldWells = builder.treeMapAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a tree map.
     * </p>
     * 
     * @return The aggregated field wells of a tree map.
     */
    public final TreeMapAggregatedFieldWells treeMapAggregatedFieldWells() {
        return treeMapAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(treeMapAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeMapFieldWells)) {
            return false;
        }
        TreeMapFieldWells other = (TreeMapFieldWells) obj;
        return Objects.equals(treeMapAggregatedFieldWells(), other.treeMapAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TreeMapFieldWells").add("TreeMapAggregatedFieldWells", treeMapAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TreeMapAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(treeMapAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TreeMapAggregatedFieldWells", TREE_MAP_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TreeMapFieldWells, T> g) {
        return obj -> g.apply((TreeMapFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TreeMapFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a tree map.
         * </p>
         * 
         * @param treeMapAggregatedFieldWells
         *        The aggregated field wells of a tree map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeMapAggregatedFieldWells(TreeMapAggregatedFieldWells treeMapAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a tree map.
         * </p>
         * This is a convenience method that creates an instance of the {@link TreeMapAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link TreeMapAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TreeMapAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #treeMapAggregatedFieldWells(TreeMapAggregatedFieldWells)}.
         * 
         * @param treeMapAggregatedFieldWells
         *        a consumer that will call methods on {@link TreeMapAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #treeMapAggregatedFieldWells(TreeMapAggregatedFieldWells)
         */
        default Builder treeMapAggregatedFieldWells(Consumer<TreeMapAggregatedFieldWells.Builder> treeMapAggregatedFieldWells) {
            return treeMapAggregatedFieldWells(TreeMapAggregatedFieldWells.builder().applyMutation(treeMapAggregatedFieldWells)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TreeMapAggregatedFieldWells treeMapAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(TreeMapFieldWells model) {
            treeMapAggregatedFieldWells(model.treeMapAggregatedFieldWells);
        }

        public final TreeMapAggregatedFieldWells.Builder getTreeMapAggregatedFieldWells() {
            return treeMapAggregatedFieldWells != null ? treeMapAggregatedFieldWells.toBuilder() : null;
        }

        public final void setTreeMapAggregatedFieldWells(TreeMapAggregatedFieldWells.BuilderImpl treeMapAggregatedFieldWells) {
            this.treeMapAggregatedFieldWells = treeMapAggregatedFieldWells != null ? treeMapAggregatedFieldWells.build() : null;
        }

        @Override
        public final Builder treeMapAggregatedFieldWells(TreeMapAggregatedFieldWells treeMapAggregatedFieldWells) {
            this.treeMapAggregatedFieldWells = treeMapAggregatedFieldWells;
            return this;
        }

        @Override
        public TreeMapFieldWells build() {
            return new TreeMapFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
