/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The general visual interactions setup for visual publish options
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualInteractionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualInteractionOptions.Builder, VisualInteractionOptions> {
    private static final SdkField<VisualMenuOption> VISUAL_MENU_OPTION_FIELD = SdkField
            .<VisualMenuOption> builder(MarshallingType.SDK_POJO).memberName("VisualMenuOption")
            .getter(getter(VisualInteractionOptions::visualMenuOption)).setter(setter(Builder::visualMenuOption))
            .constructor(VisualMenuOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualMenuOption").build()).build();

    private static final SdkField<ContextMenuOption> CONTEXT_MENU_OPTION_FIELD = SdkField
            .<ContextMenuOption> builder(MarshallingType.SDK_POJO).memberName("ContextMenuOption")
            .getter(getter(VisualInteractionOptions::contextMenuOption)).setter(setter(Builder::contextMenuOption))
            .constructor(ContextMenuOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextMenuOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_MENU_OPTION_FIELD,
            CONTEXT_MENU_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VisualMenuOption visualMenuOption;

    private final ContextMenuOption contextMenuOption;

    private VisualInteractionOptions(BuilderImpl builder) {
        this.visualMenuOption = builder.visualMenuOption;
        this.contextMenuOption = builder.contextMenuOption;
    }

    /**
     * <p>
     * The on-visual menu options for a visual.
     * </p>
     * 
     * @return The on-visual menu options for a visual.
     */
    public final VisualMenuOption visualMenuOption() {
        return visualMenuOption;
    }

    /**
     * <p>
     * The context menu options for a visual.
     * </p>
     * 
     * @return The context menu options for a visual.
     */
    public final ContextMenuOption contextMenuOption() {
        return contextMenuOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualMenuOption());
        hashCode = 31 * hashCode + Objects.hashCode(contextMenuOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualInteractionOptions)) {
            return false;
        }
        VisualInteractionOptions other = (VisualInteractionOptions) obj;
        return Objects.equals(visualMenuOption(), other.visualMenuOption())
                && Objects.equals(contextMenuOption(), other.contextMenuOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualInteractionOptions").add("VisualMenuOption", visualMenuOption())
                .add("ContextMenuOption", contextMenuOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualMenuOption":
            return Optional.ofNullable(clazz.cast(visualMenuOption()));
        case "ContextMenuOption":
            return Optional.ofNullable(clazz.cast(contextMenuOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VisualMenuOption", VISUAL_MENU_OPTION_FIELD);
        map.put("ContextMenuOption", CONTEXT_MENU_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualInteractionOptions, T> g) {
        return obj -> g.apply((VisualInteractionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualInteractionOptions> {
        /**
         * <p>
         * The on-visual menu options for a visual.
         * </p>
         * 
         * @param visualMenuOption
         *        The on-visual menu options for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualMenuOption(VisualMenuOption visualMenuOption);

        /**
         * <p>
         * The on-visual menu options for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualMenuOption.Builder} avoiding the
         * need to create one manually via {@link VisualMenuOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualMenuOption.Builder#build()} is called immediately and its
         * result is passed to {@link #visualMenuOption(VisualMenuOption)}.
         * 
         * @param visualMenuOption
         *        a consumer that will call methods on {@link VisualMenuOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualMenuOption(VisualMenuOption)
         */
        default Builder visualMenuOption(Consumer<VisualMenuOption.Builder> visualMenuOption) {
            return visualMenuOption(VisualMenuOption.builder().applyMutation(visualMenuOption).build());
        }

        /**
         * <p>
         * The context menu options for a visual.
         * </p>
         * 
         * @param contextMenuOption
         *        The context menu options for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextMenuOption(ContextMenuOption contextMenuOption);

        /**
         * <p>
         * The context menu options for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContextMenuOption.Builder} avoiding the
         * need to create one manually via {@link ContextMenuOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContextMenuOption.Builder#build()} is called immediately and its
         * result is passed to {@link #contextMenuOption(ContextMenuOption)}.
         * 
         * @param contextMenuOption
         *        a consumer that will call methods on {@link ContextMenuOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextMenuOption(ContextMenuOption)
         */
        default Builder contextMenuOption(Consumer<ContextMenuOption.Builder> contextMenuOption) {
            return contextMenuOption(ContextMenuOption.builder().applyMutation(contextMenuOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VisualMenuOption visualMenuOption;

        private ContextMenuOption contextMenuOption;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualInteractionOptions model) {
            visualMenuOption(model.visualMenuOption);
            contextMenuOption(model.contextMenuOption);
        }

        public final VisualMenuOption.Builder getVisualMenuOption() {
            return visualMenuOption != null ? visualMenuOption.toBuilder() : null;
        }

        public final void setVisualMenuOption(VisualMenuOption.BuilderImpl visualMenuOption) {
            this.visualMenuOption = visualMenuOption != null ? visualMenuOption.build() : null;
        }

        @Override
        public final Builder visualMenuOption(VisualMenuOption visualMenuOption) {
            this.visualMenuOption = visualMenuOption;
            return this;
        }

        public final ContextMenuOption.Builder getContextMenuOption() {
            return contextMenuOption != null ? contextMenuOption.toBuilder() : null;
        }

        public final void setContextMenuOption(ContextMenuOption.BuilderImpl contextMenuOption) {
            this.contextMenuOption = contextMenuOption != null ? contextMenuOption.build() : null;
        }

        @Override
        public final Builder contextMenuOption(ContextMenuOption contextMenuOption) {
            this.contextMenuOption = contextMenuOption;
            return this;
        }

        @Override
        public VisualInteractionOptions build() {
            return new VisualInteractionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
