/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoricalAggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.StringFormatConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CategoricalMeasureField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CategoricalMeasureField> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(CategoricalMeasureField.getter(CategoricalMeasureField::fieldId)).setter(CategoricalMeasureField.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(CategoricalMeasureField.getter(CategoricalMeasureField::column)).setter(CategoricalMeasureField.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<String> AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationFunction").getter(CategoricalMeasureField.getter(CategoricalMeasureField::aggregationFunctionAsString)).setter(CategoricalMeasureField.setter(Builder::aggregationFunction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build()}).build();
    private static final SdkField<StringFormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatConfiguration").getter(CategoricalMeasureField.getter(CategoricalMeasureField::formatConfiguration)).setter(CategoricalMeasureField.setter(Builder::formatConfiguration)).constructor(StringFormatConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, COLUMN_FIELD, AGGREGATION_FUNCTION_FIELD, FORMAT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CategoricalMeasureField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final ColumnIdentifier column;
    private final String aggregationFunction;
    private final StringFormatConfiguration formatConfiguration;

    private CategoricalMeasureField(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.column = builder.column;
        this.aggregationFunction = builder.aggregationFunction;
        this.formatConfiguration = builder.formatConfiguration;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final CategoricalAggregationFunction aggregationFunction() {
        return CategoricalAggregationFunction.fromValue(this.aggregationFunction);
    }

    public final String aggregationFunctionAsString() {
        return this.aggregationFunction;
    }

    public final StringFormatConfiguration formatConfiguration() {
        return this.formatConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoricalMeasureField)) {
            return false;
        }
        CategoricalMeasureField other = (CategoricalMeasureField)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.aggregationFunctionAsString(), other.aggregationFunctionAsString()) && Objects.equals(this.formatConfiguration(), other.formatConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CategoricalMeasureField").add("FieldId", (Object)this.fieldId()).add("Column", (Object)this.column()).add("AggregationFunction", (Object)this.aggregationFunctionAsString()).add("FormatConfiguration", (Object)this.formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "AggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunctionAsString()));
            }
            case "FormatConfiguration": {
                return Optional.ofNullable(clazz.cast(this.formatConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("FormatConfiguration", FORMAT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CategoricalMeasureField, T> g) {
        return obj -> g.apply((CategoricalMeasureField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private ColumnIdentifier column;
        private String aggregationFunction;
        private StringFormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoricalMeasureField model) {
            this.fieldId(model.fieldId);
            this.column(model.column);
            this.aggregationFunction(model.aggregationFunction);
            this.formatConfiguration(model.formatConfiguration);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final String getAggregationFunction() {
            return this.aggregationFunction;
        }

        public final void setAggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
        }

        @Override
        public final Builder aggregationFunction(String aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Override
        public final Builder aggregationFunction(CategoricalAggregationFunction aggregationFunction) {
            this.aggregationFunction(aggregationFunction == null ? null : aggregationFunction.toString());
            return this;
        }

        public final StringFormatConfiguration.Builder getFormatConfiguration() {
            return this.formatConfiguration != null ? this.formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(StringFormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(StringFormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        public CategoricalMeasureField build() {
            return new CategoricalMeasureField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CategoricalMeasureField> {
        public Builder fieldId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder aggregationFunction(String var1);

        public Builder aggregationFunction(CategoricalAggregationFunction var1);

        public Builder formatConfiguration(StringFormatConfiguration var1);

        default public Builder formatConfiguration(Consumer<StringFormatConfiguration.Builder> formatConfiguration) {
            return this.formatConfiguration((StringFormatConfiguration)((StringFormatConfiguration.Builder)StringFormatConfiguration.builder().applyMutation(formatConfiguration)).build());
        }
    }
}

