/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetReference;
import software.amazon.awssdk.services.quicksight.model.DataSetReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateSourceAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateSourceAnalysis> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TemplateSourceAnalysis.getter(TemplateSourceAnalysis::arn)).setter(TemplateSourceAnalysis.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<DataSetReference>> DATA_SET_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetReferences").getter(TemplateSourceAnalysis.getter(TemplateSourceAnalysis::dataSetReferences)).setter(TemplateSourceAnalysis.setter(Builder::dataSetReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateSourceAnalysis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<DataSetReference> dataSetReferences;

    private TemplateSourceAnalysis(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetReferences = builder.dataSetReferences;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasDataSetReferences() {
        return this.dataSetReferences != null && !(this.dataSetReferences instanceof SdkAutoConstructList);
    }

    public final List<DataSetReference> dataSetReferences() {
        return this.dataSetReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetReferences() ? this.dataSetReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateSourceAnalysis)) {
            return false;
        }
        TemplateSourceAnalysis other = (TemplateSourceAnalysis)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasDataSetReferences() == other.hasDataSetReferences() && Objects.equals(this.dataSetReferences(), other.dataSetReferences());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateSourceAnalysis").add("Arn", (Object)this.arn()).add("DataSetReferences", this.hasDataSetReferences() ? this.dataSetReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetReferences": {
                return Optional.ofNullable(clazz.cast(this.dataSetReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("DataSetReferences", DATA_SET_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateSourceAnalysis, T> g) {
        return obj -> g.apply((TemplateSourceAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<DataSetReference> dataSetReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateSourceAnalysis model) {
            this.arn(model.arn);
            this.dataSetReferences(model.dataSetReferences);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<DataSetReference.Builder> getDataSetReferences() {
            List<DataSetReference.Builder> result = DataSetReferenceListCopier.copyToBuilder(this.dataSetReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetReferences(Collection<DataSetReference.BuilderImpl> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copyFromBuilder(dataSetReferences);
        }

        @Override
        public final Builder dataSetReferences(Collection<DataSetReference> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copy(dataSetReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(DataSetReference ... dataSetReferences) {
            this.dataSetReferences(Arrays.asList(dataSetReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(Consumer<DataSetReference.Builder> ... dataSetReferences) {
            this.dataSetReferences(Stream.of(dataSetReferences).map(c -> (DataSetReference)((DataSetReference.Builder)DataSetReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TemplateSourceAnalysis build() {
            return new TemplateSourceAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateSourceAnalysis> {
        public Builder arn(String var1);

        public Builder dataSetReferences(Collection<DataSetReference> var1);

        public Builder dataSetReferences(DataSetReference ... var1);

        public Builder dataSetReferences(Consumer<DataSetReference.Builder> ... var1);
    }
}

