/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBSnapshotTenantDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBSnapshotTenantDatabase> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotIdentifier").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::dbSnapshotIdentifier)).setter(DBSnapshotTenantDatabase.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::dbInstanceIdentifier)).setter(DBSnapshotTenantDatabase.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbiResourceId").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::dbiResourceId)).setter(DBSnapshotTenantDatabase.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineName").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::engineName)).setter(DBSnapshotTenantDatabase.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotType").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::snapshotType)).setter(DBSnapshotTenantDatabase.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()}).build();
    private static final SdkField<Instant> TENANT_DATABASE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TenantDatabaseCreateTime").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::tenantDatabaseCreateTime)).setter(DBSnapshotTenantDatabase.setter(Builder::tenantDatabaseCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseCreateTime").build()}).build();
    private static final SdkField<String> TENANT_DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDBName").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::tenantDBName)).setter(DBSnapshotTenantDatabase.setter(Builder::tenantDBName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDBName").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::masterUsername)).setter(DBSnapshotTenantDatabase.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> TENANT_DATABASE_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TenantDatabaseResourceId").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::tenantDatabaseResourceId)).setter(DBSnapshotTenantDatabase.setter(Builder::tenantDatabaseResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantDatabaseResourceId").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::characterSetName)).setter(DBSnapshotTenantDatabase.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotTenantDatabaseARN").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::dbSnapshotTenantDatabaseARN)).setter(DBSnapshotTenantDatabase.setter(Builder::dbSnapshotTenantDatabaseARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotTenantDatabaseARN").build()}).build();
    private static final SdkField<String> NCHAR_CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NcharCharacterSetName").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::ncharCharacterSetName)).setter(DBSnapshotTenantDatabase.setter(Builder::ncharCharacterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NcharCharacterSetName").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(DBSnapshotTenantDatabase.getter(DBSnapshotTenantDatabase::tagList)).setter(DBSnapshotTenantDatabase.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DBI_RESOURCE_ID_FIELD, ENGINE_NAME_FIELD, SNAPSHOT_TYPE_FIELD, TENANT_DATABASE_CREATE_TIME_FIELD, TENANT_DB_NAME_FIELD, MASTER_USERNAME_FIELD, TENANT_DATABASE_RESOURCE_ID_FIELD, CHARACTER_SET_NAME_FIELD, DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD, NCHAR_CHARACTER_SET_NAME_FIELD, TAG_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DBSnapshotTenantDatabase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbSnapshotIdentifier;
    private final String dbInstanceIdentifier;
    private final String dbiResourceId;
    private final String engineName;
    private final String snapshotType;
    private final Instant tenantDatabaseCreateTime;
    private final String tenantDBName;
    private final String masterUsername;
    private final String tenantDatabaseResourceId;
    private final String characterSetName;
    private final String dbSnapshotTenantDatabaseARN;
    private final String ncharCharacterSetName;
    private final List<Tag> tagList;

    private DBSnapshotTenantDatabase(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbiResourceId = builder.dbiResourceId;
        this.engineName = builder.engineName;
        this.snapshotType = builder.snapshotType;
        this.tenantDatabaseCreateTime = builder.tenantDatabaseCreateTime;
        this.tenantDBName = builder.tenantDBName;
        this.masterUsername = builder.masterUsername;
        this.tenantDatabaseResourceId = builder.tenantDatabaseResourceId;
        this.characterSetName = builder.characterSetName;
        this.dbSnapshotTenantDatabaseARN = builder.dbSnapshotTenantDatabaseARN;
        this.ncharCharacterSetName = builder.ncharCharacterSetName;
        this.tagList = builder.tagList;
    }

    public final String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final String dbiResourceId() {
        return this.dbiResourceId;
    }

    public final String engineName() {
        return this.engineName;
    }

    public final String snapshotType() {
        return this.snapshotType;
    }

    public final Instant tenantDatabaseCreateTime() {
        return this.tenantDatabaseCreateTime;
    }

    public final String tenantDBName() {
        return this.tenantDBName;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String tenantDatabaseResourceId() {
        return this.tenantDatabaseResourceId;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String dbSnapshotTenantDatabaseARN() {
        return this.dbSnapshotTenantDatabaseARN;
    }

    public final String ncharCharacterSetName() {
        return this.ncharCharacterSetName;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDatabaseCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDBName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenantDatabaseResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotTenantDatabaseARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.ncharCharacterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotTenantDatabase)) {
            return false;
        }
        DBSnapshotTenantDatabase other = (DBSnapshotTenantDatabase)obj;
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.tenantDatabaseCreateTime(), other.tenantDatabaseCreateTime()) && Objects.equals(this.tenantDBName(), other.tenantDBName()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.tenantDatabaseResourceId(), other.tenantDatabaseResourceId()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.dbSnapshotTenantDatabaseARN(), other.dbSnapshotTenantDatabaseARN()) && Objects.equals(this.ncharCharacterSetName(), other.ncharCharacterSetName()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"DBSnapshotTenantDatabase").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DbiResourceId", (Object)this.dbiResourceId()).add("EngineName", (Object)this.engineName()).add("SnapshotType", (Object)this.snapshotType()).add("TenantDatabaseCreateTime", (Object)this.tenantDatabaseCreateTime()).add("TenantDBName", (Object)this.tenantDBName()).add("MasterUsername", (Object)this.masterUsername()).add("TenantDatabaseResourceId", (Object)this.tenantDatabaseResourceId()).add("CharacterSetName", (Object)this.characterSetName()).add("DBSnapshotTenantDatabaseARN", (Object)this.dbSnapshotTenantDatabaseARN()).add("NcharCharacterSetName", (Object)this.ncharCharacterSetName()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "TenantDatabaseCreateTime": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabaseCreateTime()));
            }
            case "TenantDBName": {
                return Optional.ofNullable(clazz.cast(this.tenantDBName()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "TenantDatabaseResourceId": {
                return Optional.ofNullable(clazz.cast(this.tenantDatabaseResourceId()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "DBSnapshotTenantDatabaseARN": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotTenantDatabaseARN()));
            }
            case "NcharCharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.ncharCharacterSetName()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBSnapshotIdentifier", DB_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("DbiResourceId", DBI_RESOURCE_ID_FIELD);
        map.put("EngineName", ENGINE_NAME_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("TenantDatabaseCreateTime", TENANT_DATABASE_CREATE_TIME_FIELD);
        map.put("TenantDBName", TENANT_DB_NAME_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("TenantDatabaseResourceId", TENANT_DATABASE_RESOURCE_ID_FIELD);
        map.put("CharacterSetName", CHARACTER_SET_NAME_FIELD);
        map.put("DBSnapshotTenantDatabaseARN", DB_SNAPSHOT_TENANT_DATABASE_ARN_FIELD);
        map.put("NcharCharacterSetName", NCHAR_CHARACTER_SET_NAME_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBSnapshotTenantDatabase, T> g) {
        return obj -> g.apply((DBSnapshotTenantDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String dbInstanceIdentifier;
        private String dbiResourceId;
        private String engineName;
        private String snapshotType;
        private Instant tenantDatabaseCreateTime;
        private String tenantDBName;
        private String masterUsername;
        private String tenantDatabaseResourceId;
        private String characterSetName;
        private String dbSnapshotTenantDatabaseARN;
        private String ncharCharacterSetName;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotTenantDatabase model) {
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbiResourceId(model.dbiResourceId);
            this.engineName(model.engineName);
            this.snapshotType(model.snapshotType);
            this.tenantDatabaseCreateTime(model.tenantDatabaseCreateTime);
            this.tenantDBName(model.tenantDBName);
            this.masterUsername(model.masterUsername);
            this.tenantDatabaseResourceId(model.tenantDatabaseResourceId);
            this.characterSetName(model.characterSetName);
            this.dbSnapshotTenantDatabaseARN(model.dbSnapshotTenantDatabaseARN);
            this.ncharCharacterSetName(model.ncharCharacterSetName);
            this.tagList(model.tagList);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Instant getTenantDatabaseCreateTime() {
            return this.tenantDatabaseCreateTime;
        }

        public final void setTenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
        }

        @Override
        public final Builder tenantDatabaseCreateTime(Instant tenantDatabaseCreateTime) {
            this.tenantDatabaseCreateTime = tenantDatabaseCreateTime;
            return this;
        }

        public final String getTenantDBName() {
            return this.tenantDBName;
        }

        public final void setTenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
        }

        @Override
        public final Builder tenantDBName(String tenantDBName) {
            this.tenantDBName = tenantDBName;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getTenantDatabaseResourceId() {
            return this.tenantDatabaseResourceId;
        }

        public final void setTenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
        }

        @Override
        public final Builder tenantDatabaseResourceId(String tenantDatabaseResourceId) {
            this.tenantDatabaseResourceId = tenantDatabaseResourceId;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDbSnapshotTenantDatabaseARN() {
            return this.dbSnapshotTenantDatabaseARN;
        }

        public final void setDbSnapshotTenantDatabaseARN(String dbSnapshotTenantDatabaseARN) {
            this.dbSnapshotTenantDatabaseARN = dbSnapshotTenantDatabaseARN;
        }

        @Override
        public final Builder dbSnapshotTenantDatabaseARN(String dbSnapshotTenantDatabaseARN) {
            this.dbSnapshotTenantDatabaseARN = dbSnapshotTenantDatabaseARN;
            return this;
        }

        public final String getNcharCharacterSetName() {
            return this.ncharCharacterSetName;
        }

        public final void setNcharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
        }

        @Override
        public final Builder ncharCharacterSetName(String ncharCharacterSetName) {
            this.ncharCharacterSetName = ncharCharacterSetName;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DBSnapshotTenantDatabase build() {
            return new DBSnapshotTenantDatabase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBSnapshotTenantDatabase> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder dbiResourceId(String var1);

        public Builder engineName(String var1);

        public Builder snapshotType(String var1);

        public Builder tenantDatabaseCreateTime(Instant var1);

        public Builder tenantDBName(String var1);

        public Builder masterUsername(String var1);

        public Builder tenantDatabaseResourceId(String var1);

        public Builder characterSetName(String var1);

        public Builder dbSnapshotTenantDatabaseARN(String var1);

        public Builder ncharCharacterSetName(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

