/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClientPasswordAuthType {
    MYSQL_NATIVE_PASSWORD("MYSQL_NATIVE_PASSWORD"),
    MYSQL_CACHING_SHA2_PASSWORD("MYSQL_CACHING_SHA2_PASSWORD"),
    POSTGRES_SCRAM_SHA_256("POSTGRES_SCRAM_SHA_256"),
    POSTGRES_MD5("POSTGRES_MD5"),
    SQL_SERVER_AUTHENTICATION("SQL_SERVER_AUTHENTICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClientPasswordAuthType> VALUE_MAP;
    private final String value;

    private ClientPasswordAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClientPasswordAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClientPasswordAuthType> knownValues() {
        EnumSet<ClientPasswordAuthType> knownValues = EnumSet.allOf(ClientPasswordAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClientPasswordAuthType.class, ClientPasswordAuthType::toString);
    }
}

