/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbRecommendationsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeDbRecommendationsRequest> {
    private static final SdkField<Instant> LAST_UPDATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAfter").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::lastUpdatedAfter)).setter(DescribeDbRecommendationsRequest.setter(Builder::lastUpdatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAfter").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedBefore").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::lastUpdatedBefore)).setter(DescribeDbRecommendationsRequest.setter(Builder::lastUpdatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBefore").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::locale)).setter(DescribeDbRecommendationsRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::filters)).setter(DescribeDbRecommendationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::maxRecords)).setter(DescribeDbRecommendationsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbRecommendationsRequest.getter(DescribeDbRecommendationsRequest::marker)).setter(DescribeDbRecommendationsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_AFTER_FIELD, LAST_UPDATED_BEFORE_FIELD, LOCALE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbRecommendationsRequest.memberNameToFieldInitializer();
    private final Instant lastUpdatedAfter;
    private final Instant lastUpdatedBefore;
    private final String locale;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeDbRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.lastUpdatedAfter = builder.lastUpdatedAfter;
        this.lastUpdatedBefore = builder.lastUpdatedBefore;
        this.locale = builder.locale;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final Instant lastUpdatedAfter() {
        return this.lastUpdatedAfter;
    }

    public final Instant lastUpdatedBefore() {
        return this.lastUpdatedBefore;
    }

    public final String locale() {
        return this.locale;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbRecommendationsRequest)) {
            return false;
        }
        DescribeDbRecommendationsRequest other = (DescribeDbRecommendationsRequest)((Object)obj);
        return Objects.equals(this.lastUpdatedAfter(), other.lastUpdatedAfter()) && Objects.equals(this.lastUpdatedBefore(), other.lastUpdatedBefore()) && Objects.equals(this.locale(), other.locale()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbRecommendationsRequest").add("LastUpdatedAfter", (Object)this.lastUpdatedAfter()).add("LastUpdatedBefore", (Object)this.lastUpdatedBefore()).add("Locale", (Object)this.locale()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastUpdatedAfter": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAfter()));
            }
            case "LastUpdatedBefore": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBefore()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LastUpdatedAfter", LAST_UPDATED_AFTER_FIELD);
        map.put("LastUpdatedBefore", LAST_UPDATED_BEFORE_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbRecommendationsRequest, T> g) {
        return obj -> g.apply((DescribeDbRecommendationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private Instant lastUpdatedAfter;
        private Instant lastUpdatedBefore;
        private String locale;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbRecommendationsRequest model) {
            super(model);
            this.lastUpdatedAfter(model.lastUpdatedAfter);
            this.lastUpdatedBefore(model.lastUpdatedBefore);
            this.locale(model.locale);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final Instant getLastUpdatedAfter() {
            return this.lastUpdatedAfter;
        }

        public final void setLastUpdatedAfter(Instant lastUpdatedAfter) {
            this.lastUpdatedAfter = lastUpdatedAfter;
        }

        @Override
        public final Builder lastUpdatedAfter(Instant lastUpdatedAfter) {
            this.lastUpdatedAfter = lastUpdatedAfter;
            return this;
        }

        public final Instant getLastUpdatedBefore() {
            return this.lastUpdatedBefore;
        }

        public final void setLastUpdatedBefore(Instant lastUpdatedBefore) {
            this.lastUpdatedBefore = lastUpdatedBefore;
        }

        @Override
        public final Builder lastUpdatedBefore(Instant lastUpdatedBefore) {
            this.lastUpdatedBefore = lastUpdatedBefore;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbRecommendationsRequest build() {
            return new DescribeDbRecommendationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbRecommendationsRequest> {
        public Builder lastUpdatedAfter(Instant var1);

        public Builder lastUpdatedBefore(Instant var1);

        public Builder locale(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

