/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response elements represent the output of a request to perform a rollback of a transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RollbackTransactionResponse extends RdsDataResponse implements
        ToCopyableBuilder<RollbackTransactionResponse.Builder, RollbackTransactionResponse> {
    private static final SdkField<String> TRANSACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionStatus").getter(getter(RollbackTransactionResponse::transactionStatus))
            .setter(setter(Builder::transactionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transactionStatus;

    private RollbackTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.transactionStatus = builder.transactionStatus;
    }

    /**
     * <p>
     * The status of the rollback operation.
     * </p>
     * 
     * @return The status of the rollback operation.
     */
    public final String transactionStatus() {
        return transactionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackTransactionResponse)) {
            return false;
        }
        RollbackTransactionResponse other = (RollbackTransactionResponse) obj;
        return Objects.equals(transactionStatus(), other.transactionStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RollbackTransactionResponse").add("TransactionStatus", transactionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionStatus":
            return Optional.ofNullable(clazz.cast(transactionStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactionStatus", TRANSACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RollbackTransactionResponse, T> g) {
        return obj -> g.apply((RollbackTransactionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, RollbackTransactionResponse> {
        /**
         * <p>
         * The status of the rollback operation.
         * </p>
         * 
         * @param transactionStatus
         *        The status of the rollback operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionStatus(String transactionStatus);
    }

    static final class BuilderImpl extends RdsDataResponse.BuilderImpl implements Builder {
        private String transactionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RollbackTransactionResponse model) {
            super(model);
            transactionStatus(model.transactionStatus);
        }

        public final String getTransactionStatus() {
            return transactionStatus;
        }

        public final void setTransactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public final Builder transactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
            return this;
        }

        @Override
        public RollbackTransactionResponse build() {
            return new RollbackTransactionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
