/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevision;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevisionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterDbRevisionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterDbRevisionsResponse.getter(DescribeClusterDbRevisionsResponse::marker)).setter(DescribeClusterDbRevisionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ClusterDbRevision>> CLUSTER_DB_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterDbRevisions").getter(DescribeClusterDbRevisionsResponse.getter(DescribeClusterDbRevisionsResponse::clusterDbRevisions)).setter(DescribeClusterDbRevisionsResponse.setter(Builder::clusterDbRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterDbRevisions").build(), ListTrait.builder().memberLocationName("ClusterDbRevision").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterDbRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterDbRevision").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTER_DB_REVISIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterDbRevisionsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<ClusterDbRevision> clusterDbRevisions;

    private DescribeClusterDbRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterDbRevisions = builder.clusterDbRevisions;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasClusterDbRevisions() {
        return this.clusterDbRevisions != null && !(this.clusterDbRevisions instanceof SdkAutoConstructList);
    }

    public final List<ClusterDbRevision> clusterDbRevisions() {
        return this.clusterDbRevisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterDbRevisions() ? this.clusterDbRevisions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterDbRevisionsResponse)) {
            return false;
        }
        DescribeClusterDbRevisionsResponse other = (DescribeClusterDbRevisionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasClusterDbRevisions() == other.hasClusterDbRevisions() && Objects.equals(this.clusterDbRevisions(), other.clusterDbRevisions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterDbRevisionsResponse").add("Marker", (Object)this.marker()).add("ClusterDbRevisions", this.hasClusterDbRevisions() ? this.clusterDbRevisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ClusterDbRevisions": {
                return Optional.ofNullable(clazz.cast(this.clusterDbRevisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("ClusterDbRevisions", CLUSTER_DB_REVISIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterDbRevisionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterDbRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterDbRevision> clusterDbRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterDbRevisionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterDbRevisions(model.clusterDbRevisions);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterDbRevision.Builder> getClusterDbRevisions() {
            List<ClusterDbRevision.Builder> result = ClusterDbRevisionsListCopier.copyToBuilder(this.clusterDbRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterDbRevisions(Collection<ClusterDbRevision.BuilderImpl> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copyFromBuilder(clusterDbRevisions);
        }

        @Override
        public final Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copy(clusterDbRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(ClusterDbRevision ... clusterDbRevisions) {
            this.clusterDbRevisions(Arrays.asList(clusterDbRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder> ... clusterDbRevisions) {
            this.clusterDbRevisions(Stream.of(clusterDbRevisions).map(c -> (ClusterDbRevision)((ClusterDbRevision.Builder)ClusterDbRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterDbRevisionsResponse build() {
            return new DescribeClusterDbRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
        public Builder marker(String var1);

        public Builder clusterDbRevisions(Collection<ClusterDbRevision> var1);

        public Builder clusterDbRevisions(ClusterDbRevision ... var1);

        public Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder> ... var1);
    }
}

