/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterIamRolesRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyClusterIamRolesRequest.getter(ModifyClusterIamRolesRequest::clusterIdentifier)).setter(ModifyClusterIamRolesRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<List<String>> ADD_IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddIamRoles").getter(ModifyClusterIamRolesRequest.getter(ModifyClusterIamRolesRequest::addIamRoles)).setter(ModifyClusterIamRolesRequest.setter(Builder::addIamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddIamRoles").build(), ListTrait.builder().memberLocationName("IamRoleArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveIamRoles").getter(ModifyClusterIamRolesRequest.getter(ModifyClusterIamRolesRequest::removeIamRoles)).setter(ModifyClusterIamRolesRequest.setter(Builder::removeIamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveIamRoles").build(), ListTrait.builder().memberLocationName("IamRoleArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultIamRoleArn").getter(ModifyClusterIamRolesRequest.getter(ModifyClusterIamRolesRequest::defaultIamRoleArn)).setter(ModifyClusterIamRolesRequest.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultIamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, ADD_IAM_ROLES_FIELD, REMOVE_IAM_ROLES_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyClusterIamRolesRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final List<String> addIamRoles;
    private final List<String> removeIamRoles;
    private final String defaultIamRoleArn;

    private ModifyClusterIamRolesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.addIamRoles = builder.addIamRoles;
        this.removeIamRoles = builder.removeIamRoles;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final boolean hasAddIamRoles() {
        return this.addIamRoles != null && !(this.addIamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> addIamRoles() {
        return this.addIamRoles;
    }

    public final boolean hasRemoveIamRoles() {
        return this.removeIamRoles != null && !(this.removeIamRoles instanceof SdkAutoConstructList);
    }

    public final List<String> removeIamRoles() {
        return this.removeIamRoles;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddIamRoles() ? this.addIamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveIamRoles() ? this.removeIamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterIamRolesRequest)) {
            return false;
        }
        ModifyClusterIamRolesRequest other = (ModifyClusterIamRolesRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && this.hasAddIamRoles() == other.hasAddIamRoles() && Objects.equals(this.addIamRoles(), other.addIamRoles()) && this.hasRemoveIamRoles() == other.hasRemoveIamRoles() && Objects.equals(this.removeIamRoles(), other.removeIamRoles()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyClusterIamRolesRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("AddIamRoles", this.hasAddIamRoles() ? this.addIamRoles() : null).add("RemoveIamRoles", this.hasRemoveIamRoles() ? this.removeIamRoles() : null).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "AddIamRoles": {
                return Optional.ofNullable(clazz.cast(this.addIamRoles()));
            }
            case "RemoveIamRoles": {
                return Optional.ofNullable(clazz.cast(this.removeIamRoles()));
            }
            case "DefaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("AddIamRoles", ADD_IAM_ROLES_FIELD);
        map.put("RemoveIamRoles", REMOVE_IAM_ROLES_FIELD);
        map.put("DefaultIamRoleArn", DEFAULT_IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterIamRolesRequest, T> g) {
        return obj -> g.apply((ModifyClusterIamRolesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private List<String> addIamRoles = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeIamRoles = DefaultSdkAutoConstructList.getInstance();
        private String defaultIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterIamRolesRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.addIamRoles(model.addIamRoles);
            this.removeIamRoles(model.removeIamRoles);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Collection<String> getAddIamRoles() {
            if (this.addIamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addIamRoles;
        }

        public final void setAddIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
        }

        @Override
        public final Builder addIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addIamRoles(String ... addIamRoles) {
            this.addIamRoles(Arrays.asList(addIamRoles));
            return this;
        }

        public final Collection<String> getRemoveIamRoles() {
            if (this.removeIamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeIamRoles;
        }

        public final void setRemoveIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
        }

        @Override
        public final Builder removeIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIamRoles(String ... removeIamRoles) {
            this.removeIamRoles(Arrays.asList(removeIamRoles));
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterIamRolesRequest build() {
            return new ModifyClusterIamRolesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder addIamRoles(Collection<String> var1);

        public Builder addIamRoles(String ... var1);

        public Builder removeIamRoles(Collection<String> var1);

        public Builder removeIamRoles(String ... var1);

        public Builder defaultIamRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

