/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends RekognitionRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField
            .<DatasetSource> builder(MarshallingType.SDK_POJO).memberName("DatasetSource")
            .getter(getter(CreateDatasetRequest::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DatasetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSource").build()).build();

    private static final SdkField<String> DATASET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetType").getter(getter(CreateDatasetRequest::datasetTypeAsString))
            .setter(setter(Builder::datasetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetType").build()).build();

    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectArn").getter(getter(CreateDatasetRequest::projectArn)).setter(setter(Builder::projectArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_SOURCE_FIELD,
            DATASET_TYPE_FIELD, PROJECT_ARN_FIELD, TAGS_FIELD));

    private final DatasetSource datasetSource;

    private final String datasetType;

    private final String projectArn;

    private final Map<String, String> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetSource = builder.datasetSource;
        this.datasetType = builder.datasetType;
        this.projectArn = builder.projectArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3 bucket
     * location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>, an empty
     * dataset is created. To add labeled images to the dataset, You can use the console or call
     * <a>UpdateDatasetEntries</a>.
     * </p>
     * 
     * @return The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
     *         bucket location of an Amazon Sagemaker format manifest file. If you don't specify
     *         <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can
     *         use the console or call <a>UpdateDatasetEntries</a>.
     */
    public final DatasetSource datasetSource() {
        return datasetSource;
    }

    /**
     * <p>
     * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code> to
     * create a test dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
     *         <code>TEST</code> to create a test dataset.
     * @see DatasetType
     */
    public final DatasetType datasetType() {
        return DatasetType.fromValue(datasetType);
    }

    /**
     * <p>
     * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code> to
     * create a test dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #datasetType} will
     * return {@link DatasetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #datasetTypeAsString}.
     * </p>
     * 
     * @return The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
     *         <code>TEST</code> to create a test dataset.
     * @see DatasetType
     */
    public final String datasetTypeAsString() {
        return datasetType;
    }

    /**
     * <p>
     * The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
     * </p>
     * 
     * @return The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
     */
    public final String projectArn() {
        return projectArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of tags (key-value pairs) that you want to attach to the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of tags (key-value pairs) that you want to attach to the dataset.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(datasetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(datasetSource(), other.datasetSource())
                && Objects.equals(datasetTypeAsString(), other.datasetTypeAsString())
                && Objects.equals(projectArn(), other.projectArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("DatasetSource", datasetSource())
                .add("DatasetType", datasetTypeAsString()).add("ProjectArn", projectArn()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        case "DatasetType":
            return Optional.ofNullable(clazz.cast(datasetTypeAsString()));
        case "ProjectArn":
            return Optional.ofNullable(clazz.cast(projectArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RekognitionRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
         * bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>,
         * an empty dataset is created. To add labeled images to the dataset, You can use the console or call
         * <a>UpdateDatasetEntries</a>.
         * </p>
         * 
         * @param datasetSource
         *        The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon
         *        S3 bucket location of an Amazon Sagemaker format manifest file. If you don't specify
         *        <code>datasetSource</code>, an empty dataset is created. To add labeled images to the dataset, You can
         *        use the console or call <a>UpdateDatasetEntries</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DatasetSource datasetSource);

        /**
         * <p>
         * The source files for the dataset. You can specify the ARN of an existing dataset or specify the Amazon S3
         * bucket location of an Amazon Sagemaker format manifest file. If you don't specify <code>datasetSource</code>,
         * an empty dataset is created. To add labeled images to the dataset, You can use the console or call
         * <a>UpdateDatasetEntries</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetSource.Builder} avoiding the need
         * to create one manually via {@link DatasetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetSource.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSource(DatasetSource)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DatasetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DatasetSource)
         */
        default Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return datasetSource(DatasetSource.builder().applyMutation(datasetSource).build());
        }

        /**
         * <p>
         * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code>
         * to create a test dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
         *        <code>TEST</code> to create a test dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(String datasetType);

        /**
         * <p>
         * The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify <code>TEST</code>
         * to create a test dataset.
         * </p>
         * 
         * @param datasetType
         *        The type of the dataset. Specify <code>TRAIN</code> to create a training dataset. Specify
         *        <code>TEST</code> to create a test dataset.
         * @see DatasetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetType
         */
        Builder datasetType(DatasetType datasetType);

        /**
         * <p>
         * The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
         * </p>
         * 
         * @param projectArn
         *        The ARN of the Amazon Rekognition Custom Labels project to which you want to asssign the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectArn(String projectArn);

        /**
         * <p>
         * A set of tags (key-value pairs) that you want to attach to the dataset.
         * </p>
         * 
         * @param tags
         *        A set of tags (key-value pairs) that you want to attach to the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RekognitionRequest.BuilderImpl implements Builder {
        private DatasetSource datasetSource;

        private String datasetType;

        private String projectArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            datasetSource(model.datasetSource);
            datasetType(model.datasetType);
            projectArn(model.projectArn);
            tags(model.tags);
        }

        public final DatasetSource.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final String getDatasetType() {
            return datasetType;
        }

        public final void setDatasetType(String datasetType) {
            this.datasetType = datasetType;
        }

        @Override
        public final Builder datasetType(String datasetType) {
            this.datasetType = datasetType;
            return this;
        }

        @Override
        public final Builder datasetType(DatasetType datasetType) {
            this.datasetType(datasetType == null ? null : datasetType.toString());
            return this;
        }

        public final String getProjectArn() {
            return projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
