/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.TagSyncTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagSyncTaskItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagSyncTaskItem> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupArn").getter(TagSyncTaskItem.getter(TagSyncTaskItem::groupArn)).setter(TagSyncTaskItem.setter(Builder::groupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(TagSyncTaskItem.getter(TagSyncTaskItem::groupName)).setter(TagSyncTaskItem.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskArn").getter(TagSyncTaskItem.getter(TagSyncTaskItem::taskArn)).setter(TagSyncTaskItem.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(TagSyncTaskItem.getter(TagSyncTaskItem::tagKey)).setter(TagSyncTaskItem.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValue").getter(TagSyncTaskItem.getter(TagSyncTaskItem::tagValue)).setter(TagSyncTaskItem.setter(Builder::tagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(TagSyncTaskItem.getter(TagSyncTaskItem::roleArn)).setter(TagSyncTaskItem.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TagSyncTaskItem.getter(TagSyncTaskItem::statusAsString)).setter(TagSyncTaskItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(TagSyncTaskItem.getter(TagSyncTaskItem::errorMessage)).setter(TagSyncTaskItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(TagSyncTaskItem.getter(TagSyncTaskItem::createdAt)).setter(TagSyncTaskItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD, GROUP_NAME_FIELD, TASK_ARN_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GroupArn", GROUP_ARN_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("TaskArn", TASK_ARN_FIELD);
            this.put("TagKey", TAG_KEY_FIELD);
            this.put("TagValue", TAG_VALUE_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String groupArn;
    private final String groupName;
    private final String taskArn;
    private final String tagKey;
    private final String tagValue;
    private final String roleArn;
    private final String status;
    private final String errorMessage;
    private final Instant createdAt;

    private TagSyncTaskItem(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
        this.groupName = builder.groupName;
        this.taskArn = builder.taskArn;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.createdAt = builder.createdAt;
    }

    public final String groupArn() {
        return this.groupArn;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final String tagValue() {
        return this.tagValue;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final TagSyncTaskStatus status() {
        return TagSyncTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagSyncTaskItem)) {
            return false;
        }
        TagSyncTaskItem other = (TagSyncTaskItem)obj;
        return Objects.equals(this.groupArn(), other.groupArn()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"TagSyncTaskItem").add("GroupArn", (Object)this.groupArn()).add("GroupName", (Object)this.groupName()).add("TaskArn", (Object)this.taskArn()).add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupArn": {
                return Optional.ofNullable(clazz.cast(this.groupArn()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TagSyncTaskItem, T> g) {
        return obj -> g.apply((TagSyncTaskItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupArn;
        private String groupName;
        private String taskArn;
        private String tagKey;
        private String tagValue;
        private String roleArn;
        private String status;
        private String errorMessage;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TagSyncTaskItem model) {
            this.groupArn(model.groupArn);
            this.groupName(model.groupName);
            this.taskArn(model.taskArn);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.errorMessage(model.errorMessage);
            this.createdAt(model.createdAt);
        }

        public final String getGroupArn() {
            return this.groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TagSyncTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public TagSyncTaskItem build() {
            return new TagSyncTaskItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagSyncTaskItem> {
        public Builder groupArn(String var1);

        public Builder groupName(String var1);

        public Builder taskArn(String var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(TagSyncTaskStatus var1);

        public Builder errorMessage(String var1);

        public Builder createdAt(Instant var1);
    }
}

