/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem;
import software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ResourceQuery;
import software.amazon.awssdk.services.resourcegroups.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateGroupRequest.getter(CreateGroupRequest::name)).setter(CreateGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateGroupRequest.getter(CreateGroupRequest::description)).setter(CreateGroupRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceQuery").getter(CreateGroupRequest.getter(CreateGroupRequest::resourceQuery)).setter(CreateGroupRequest.setter(Builder::resourceQuery)).constructor(ResourceQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateGroupRequest.getter(CreateGroupRequest::tags)).setter(CreateGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configuration").getter(CreateGroupRequest.getter(CreateGroupRequest::configuration)).setter(CreateGroupRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupConfigurationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(CreateGroupRequest.getter(CreateGroupRequest::criticality)).setter(CreateGroupRequest.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(CreateGroupRequest.getter(CreateGroupRequest::owner)).setter(CreateGroupRequest.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateGroupRequest.getter(CreateGroupRequest::displayName)).setter(CreateGroupRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RESOURCE_QUERY_FIELD, TAGS_FIELD, CONFIGURATION_FIELD, CRITICALITY_FIELD, OWNER_FIELD, DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final ResourceQuery resourceQuery;
    private final Map<String, String> tags;
    private final List<GroupConfigurationItem> configuration;
    private final Integer criticality;
    private final String owner;
    private final String displayName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
        this.configuration = builder.configuration;
        this.criticality = builder.criticality;
        this.owner = builder.owner;
        this.displayName = builder.displayName;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ResourceQuery resourceQuery() {
        return this.resourceQuery;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructList);
    }

    public final List<GroupConfigurationItem> configuration() {
        return this.configuration;
    }

    public final Integer criticality() {
        return this.criticality;
    }

    public final String owner() {
        return this.owner;
    }

    public final String displayName() {
        return this.displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.resourceQuery(), other.resourceQuery()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.criticality(), other.criticality()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGroupRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ResourceQuery", (Object)this.resourceQuery()).add("Tags", this.hasTags() ? this.tags() : null).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("Criticality", (Object)this.criticality()).add("Owner", (Object)this.owner()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ResourceQuery": {
                return Optional.ofNullable(clazz.cast(this.resourceQuery()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ResourceQuery", RESOURCE_QUERY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ResourceQuery resourceQuery;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();
        private Integer criticality;
        private String owner;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.resourceQuery(model.resourceQuery);
            this.tags(model.tags);
            this.configuration(model.configuration);
            this.criticality(model.criticality);
            this.owner(model.owner);
            this.displayName(model.displayName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return this.resourceQuery != null ? this.resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<GroupConfigurationItem.Builder> getConfiguration() {
            List<GroupConfigurationItem.Builder> result = GroupConfigurationListCopier.copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem ... configuration) {
            this.configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder> ... configuration) {
            this.configuration(Stream.of(configuration).map(c -> (GroupConfigurationItem)((GroupConfigurationItem.Builder)GroupConfigurationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder resourceQuery(ResourceQuery var1);

        default public Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return this.resourceQuery((ResourceQuery)((ResourceQuery.Builder)ResourceQuery.builder().applyMutation(resourceQuery)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder configuration(Collection<GroupConfigurationItem> var1);

        public Builder configuration(GroupConfigurationItem ... var1);

        public Builder configuration(Consumer<GroupConfigurationItem.Builder> ... var1);

        public Builder criticality(Integer var1);

        public Builder owner(String var1);

        public Builder displayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

