/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal;

import java.util.function.Predicate;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.StandardRetryStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.internal.BaseRetryStrategy;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucketStore;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class DefaultStandardRetryStrategy
extends BaseRetryStrategy
implements StandardRetryStrategy {
    private static final Logger LOG = Logger.loggerFor(DefaultStandardRetryStrategy.class);

    DefaultStandardRetryStrategy(Builder builder) {
        super(LOG, builder);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseRetryStrategy.Builder
    implements StandardRetryStrategy.Builder {
        Builder() {
        }

        Builder(DefaultStandardRetryStrategy strategy) {
            super(strategy);
        }

        public Builder retryOnException(Predicate<Throwable> shouldRetry) {
            this.setRetryOnException(shouldRetry);
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.setMaxAttempts(maxAttempts);
            return this;
        }

        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.setBackoffStrategy(backoffStrategy);
            return this;
        }

        public Builder throttlingBackoffStrategy(BackoffStrategy throttlingBackoffStrategy) {
            this.setThrottlingBackoffStrategy(throttlingBackoffStrategy);
            return this;
        }

        public Builder treatAsThrottling(Predicate<Throwable> treatAsThrottling) {
            this.setTreatAsThrottling(treatAsThrottling);
            return this;
        }

        @Override
        public Builder circuitBreakerEnabled(Boolean circuitBreakerEnabled) {
            this.setCircuitBreakerEnabled(circuitBreakerEnabled);
            return this;
        }

        public Builder tokenBucketExceptionCost(int exceptionCost) {
            this.setTokenBucketExceptionCost(exceptionCost);
            return this;
        }

        public Builder tokenBucketStore(TokenBucketStore tokenBucketStore) {
            this.setTokenBucketStore(tokenBucketStore);
            return this;
        }

        public Builder useClientDefaults(boolean useClientDefaults) {
            this.setUseClientDefaults(useClientDefaults);
            return this;
        }

        @Override
        public StandardRetryStrategy build() {
            return new DefaultStandardRetryStrategy(this);
        }
    }
}

