/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.Fleet;
import software.amazon.awssdk.services.robomaker.model.FleetsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFleetsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListFleetsResponse> {
    private static final SdkField<List<Fleet>> FLEET_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleetDetails").getter(ListFleetsResponse.getter(ListFleetsResponse::fleetDetails)).setter(ListFleetsResponse.setter(Builder::fleetDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Fleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFleetsResponse.getter(ListFleetsResponse::nextToken)).setter(ListFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_DETAILS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFleetsResponse.memberNameToFieldInitializer();
    private final List<Fleet> fleetDetails;
    private final String nextToken;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetDetails = builder.fleetDetails;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFleetDetails() {
        return this.fleetDetails != null && !(this.fleetDetails instanceof SdkAutoConstructList);
    }

    public final List<Fleet> fleetDetails() {
        return this.fleetDetails;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetDetails() ? this.fleetDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse)((Object)obj);
        return this.hasFleetDetails() == other.hasFleetDetails() && Objects.equals(this.fleetDetails(), other.fleetDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFleetsResponse").add("FleetDetails", this.hasFleetDetails() ? this.fleetDetails() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fleetDetails": {
                return Optional.ofNullable(clazz.cast(this.fleetDetails()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fleetDetails", FLEET_DETAILS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsResponse, T> g) {
        return obj -> g.apply((ListFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<Fleet> fleetDetails = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            super(model);
            this.fleetDetails(model.fleetDetails);
            this.nextToken(model.nextToken);
        }

        public final List<Fleet.Builder> getFleetDetails() {
            List<Fleet.Builder> result = FleetsCopier.copyToBuilder(this.fleetDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetDetails(Collection<Fleet.BuilderImpl> fleetDetails) {
            this.fleetDetails = FleetsCopier.copyFromBuilder(fleetDetails);
        }

        @Override
        public final Builder fleetDetails(Collection<Fleet> fleetDetails) {
            this.fleetDetails = FleetsCopier.copy(fleetDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDetails(Fleet ... fleetDetails) {
            this.fleetDetails(Arrays.asList(fleetDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetDetails(Consumer<Fleet.Builder> ... fleetDetails) {
            this.fleetDetails(Stream.of(fleetDetails).map(c -> (Fleet)((Fleet.Builder)Fleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFleetsResponse> {
        public Builder fleetDetails(Collection<Fleet> var1);

        public Builder fleetDetails(Fleet ... var1);

        public Builder fleetDetails(Consumer<Fleet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

