/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.CidrCollectionChange;
import software.amazon.awssdk.services.route53.model.CidrCollectionChangesCopier;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeCidrCollectionRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ChangeCidrCollectionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ChangeCidrCollectionRequest.getter(ChangeCidrCollectionRequest::id)).setter(ChangeCidrCollectionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CidrCollectionId").unmarshallLocationName("CidrCollectionId").build()}).build();
    private static final SdkField<Long> COLLECTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CollectionVersion").getter(ChangeCidrCollectionRequest.getter(ChangeCidrCollectionRequest::collectionVersion)).setter(ChangeCidrCollectionRequest.setter(Builder::collectionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionVersion").unmarshallLocationName("CollectionVersion").build()}).build();
    private static final SdkField<List<CidrCollectionChange>> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Changes").getter(ChangeCidrCollectionRequest.getter(ChangeCidrCollectionRequest::changes)).setter(ChangeCidrCollectionRequest.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Changes").unmarshallLocationName("Changes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CidrCollectionChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, COLLECTION_VERSION_FIELD, CHANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CidrCollectionId", ID_FIELD);
            this.put("CollectionVersion", COLLECTION_VERSION_FIELD);
            this.put("Changes", CHANGES_FIELD);
        }
    });
    private final String id;
    private final Long collectionVersion;
    private final List<CidrCollectionChange> changes;

    private ChangeCidrCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.collectionVersion = builder.collectionVersion;
        this.changes = builder.changes;
    }

    public final String id() {
        return this.id;
    }

    public final Long collectionVersion() {
        return this.collectionVersion;
    }

    public final boolean hasChanges() {
        return this.changes != null && !(this.changes instanceof SdkAutoConstructList);
    }

    public final List<CidrCollectionChange> changes() {
        return this.changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChanges() ? this.changes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeCidrCollectionRequest)) {
            return false;
        }
        ChangeCidrCollectionRequest other = (ChangeCidrCollectionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.collectionVersion(), other.collectionVersion()) && this.hasChanges() == other.hasChanges() && Objects.equals(this.changes(), other.changes());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeCidrCollectionRequest").add("Id", (Object)this.id()).add("CollectionVersion", (Object)this.collectionVersion()).add("Changes", this.hasChanges() ? this.changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CollectionVersion": {
                return Optional.ofNullable(clazz.cast(this.collectionVersion()));
            }
            case "Changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangeCidrCollectionRequest, T> g) {
        return obj -> g.apply((ChangeCidrCollectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private Long collectionVersion;
        private List<CidrCollectionChange> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeCidrCollectionRequest model) {
            super(model);
            this.id(model.id);
            this.collectionVersion(model.collectionVersion);
            this.changes(model.changes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getCollectionVersion() {
            return this.collectionVersion;
        }

        public final void setCollectionVersion(Long collectionVersion) {
            this.collectionVersion = collectionVersion;
        }

        @Override
        public final Builder collectionVersion(Long collectionVersion) {
            this.collectionVersion = collectionVersion;
            return this;
        }

        public final List<CidrCollectionChange.Builder> getChanges() {
            List<CidrCollectionChange.Builder> result = CidrCollectionChangesCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<CidrCollectionChange.BuilderImpl> changes) {
            this.changes = CidrCollectionChangesCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<CidrCollectionChange> changes) {
            this.changes = CidrCollectionChangesCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(CidrCollectionChange ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<CidrCollectionChange.Builder> ... changes) {
            this.changes(Stream.of(changes).map(c -> (CidrCollectionChange)((CidrCollectionChange.Builder)CidrCollectionChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChangeCidrCollectionRequest build() {
            return new ChangeCidrCollectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChangeCidrCollectionRequest> {
        public Builder id(String var1);

        public Builder collectionVersion(Long var1);

        public Builder changes(Collection<CidrCollectionChange> var1);

        public Builder changes(CidrCollectionChange ... var1);

        public Builder changes(Consumer<CidrCollectionChange.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

