/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficPolicySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficPolicySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(TrafficPolicySummary.getter(TrafficPolicySummary::id)).setter(TrafficPolicySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TrafficPolicySummary.getter(TrafficPolicySummary::name)).setter(TrafficPolicySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TrafficPolicySummary.getter(TrafficPolicySummary::typeAsString)).setter(TrafficPolicySummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").unmarshallLocationName("Type").build()}).build();
    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatestVersion").getter(TrafficPolicySummary.getter(TrafficPolicySummary::latestVersion)).setter(TrafficPolicySummary.setter(Builder::latestVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").unmarshallLocationName("LatestVersion").build()}).build();
    private static final SdkField<Integer> TRAFFIC_POLICY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrafficPolicyCount").getter(TrafficPolicySummary.getter(TrafficPolicySummary::trafficPolicyCount)).setter(TrafficPolicySummary.setter(Builder::trafficPolicyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyCount").unmarshallLocationName("TrafficPolicyCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, TYPE_FIELD, LATEST_VERSION_FIELD, TRAFFIC_POLICY_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("LatestVersion", LATEST_VERSION_FIELD);
            this.put("TrafficPolicyCount", TRAFFIC_POLICY_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String type;
    private final Integer latestVersion;
    private final Integer trafficPolicyCount;

    private TrafficPolicySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.latestVersion = builder.latestVersion;
        this.trafficPolicyCount = builder.trafficPolicyCount;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final RRType type() {
        return RRType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer latestVersion() {
        return this.latestVersion;
    }

    public final Integer trafficPolicyCount() {
        return this.trafficPolicyCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicySummary)) {
            return false;
        }
        TrafficPolicySummary other = (TrafficPolicySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.latestVersion(), other.latestVersion()) && Objects.equals(this.trafficPolicyCount(), other.trafficPolicyCount());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficPolicySummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("LatestVersion", (Object)this.latestVersion()).add("TrafficPolicyCount", (Object)this.trafficPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LatestVersion": {
                return Optional.ofNullable(clazz.cast(this.latestVersion()));
            }
            case "TrafficPolicyCount": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrafficPolicySummary, T> g) {
        return obj -> g.apply((TrafficPolicySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String type;
        private Integer latestVersion;
        private Integer trafficPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicySummary model) {
            this.id(model.id);
            this.name(model.name);
            this.type(model.type);
            this.latestVersion(model.latestVersion);
            this.trafficPolicyCount(model.trafficPolicyCount);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getLatestVersion() {
            return this.latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTrafficPolicyCount() {
            return this.trafficPolicyCount;
        }

        public final void setTrafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
        }

        @Override
        public final Builder trafficPolicyCount(Integer trafficPolicyCount) {
            this.trafficPolicyCount = trafficPolicyCount;
            return this;
        }

        public TrafficPolicySummary build() {
            return new TrafficPolicySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficPolicySummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(RRType var1);

        public Builder latestVersion(Integer var1);

        public Builder trafficPolicyCount(Integer var1);
    }
}

