/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetAddress> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(TargetAddress.getter(TargetAddress::ip)).setter(TargetAddress.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(TargetAddress.getter(TargetAddress::port)).setter(TargetAddress.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ipv6").getter(TargetAddress.getter(TargetAddress::ipv6)).setter(TargetAddress.setter(Builder::ipv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TargetAddress.getter(TargetAddress::protocolAsString)).setter(TargetAddress.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SERVER_NAME_INDICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerNameIndication").getter(TargetAddress.getter(TargetAddress::serverNameIndication)).setter(TargetAddress.setter(Builder::serverNameIndication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerNameIndication").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD, IPV6_FIELD, PROTOCOL_FIELD, SERVER_NAME_INDICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetAddress.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ip;
    private final Integer port;
    private final String ipv6;
    private final String protocol;
    private final String serverNameIndication;

    private TargetAddress(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.ipv6 = builder.ipv6;
        this.protocol = builder.protocol;
        this.serverNameIndication = builder.serverNameIndication;
    }

    public final String ip() {
        return this.ip;
    }

    public final Integer port() {
        return this.port;
    }

    public final String ipv6() {
        return this.ipv6;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String serverNameIndication() {
        return this.serverNameIndication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverNameIndication());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAddress)) {
            return false;
        }
        TargetAddress other = (TargetAddress)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.ipv6(), other.ipv6()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.serverNameIndication(), other.serverNameIndication());
    }

    public final String toString() {
        return ToString.builder((String)"TargetAddress").add("Ip", (Object)this.ip()).add("Port", (Object)this.port()).add("Ipv6", (Object)this.ipv6()).add("Protocol", (Object)this.protocolAsString()).add("ServerNameIndication", (Object)this.serverNameIndication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Ipv6": {
                return Optional.ofNullable(clazz.cast(this.ipv6()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "ServerNameIndication": {
                return Optional.ofNullable(clazz.cast(this.serverNameIndication()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ip", IP_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("Ipv6", IPV6_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("ServerNameIndication", SERVER_NAME_INDICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetAddress, T> g) {
        return obj -> g.apply((TargetAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private Integer port;
        private String ipv6;
        private String protocol;
        private String serverNameIndication;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetAddress model) {
            this.ip(model.ip);
            this.port(model.port);
            this.ipv6(model.ipv6);
            this.protocol(model.protocol);
            this.serverNameIndication(model.serverNameIndication);
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getIpv6() {
            return this.ipv6;
        }

        public final void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        @Override
        public final Builder ipv6(String ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getServerNameIndication() {
            return this.serverNameIndication;
        }

        public final void setServerNameIndication(String serverNameIndication) {
            this.serverNameIndication = serverNameIndication;
        }

        @Override
        public final Builder serverNameIndication(String serverNameIndication) {
            this.serverNameIndication = serverNameIndication;
            return this;
        }

        public TargetAddress build() {
            return new TargetAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetAddress> {
        public Builder ip(String var1);

        public Builder port(Integer var1);

        public Builder ipv6(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder serverNameIndication(String var1);
    }
}

