/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GranteeType {
    DIRECTORY_USER("DIRECTORY_USER"),
    DIRECTORY_GROUP("DIRECTORY_GROUP"),
    IAM("IAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GranteeType> VALUE_MAP;
    private final String value;

    private GranteeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GranteeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GranteeType> knownValues() {
        EnumSet<GranteeType> knownValues = EnumSet.allOf(GranteeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GranteeType.class, GranteeType::toString);
    }
}

