/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReplicationStorageClass {
    STANDARD("STANDARD"),
    REDUCED_REDUNDANCY("REDUCED_REDUNDANCY"),
    STANDARD_IA("STANDARD_IA"),
    ONEZONE_IA("ONEZONE_IA"),
    INTELLIGENT_TIERING("INTELLIGENT_TIERING"),
    GLACIER("GLACIER"),
    DEEP_ARCHIVE("DEEP_ARCHIVE"),
    OUTPOSTS("OUTPOSTS"),
    GLACIER_IR("GLACIER_IR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReplicationStorageClass> VALUE_MAP;
    private final String value;

    private ReplicationStorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReplicationStorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReplicationStorageClass> knownValues() {
        EnumSet<ReplicationStorageClass> knownValues = EnumSet.allOf(ReplicationStorageClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReplicationStorageClass.class, ReplicationStorageClass::toString);
    }
}

