/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ObjectLockMode {
    COMPLIANCE("COMPLIANCE"),
    GOVERNANCE("GOVERNANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ObjectLockMode> VALUE_MAP;
    private final String value;

    private S3ObjectLockMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ObjectLockMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ObjectLockMode> knownValues() {
        EnumSet<S3ObjectLockMode> knownValues = EnumSet.allOf(S3ObjectLockMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ObjectLockMode.class, S3ObjectLockMode::toString);
    }
}

