/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableMaintenanceJobStatusResponse extends S3TablesResponse implements
        ToCopyableBuilder<GetTableMaintenanceJobStatusResponse.Builder, GetTableMaintenanceJobStatusResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableARN").getter(getter(GetTableMaintenanceJobStatusResponse::tableARN))
            .setter(setter(Builder::tableARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()).build();

    private static final SdkField<Map<String, TableMaintenanceJobStatusValue>> STATUS_FIELD = SdkField
            .<Map<String, TableMaintenanceJobStatusValue>> builder(MarshallingType.MAP)
            .memberName("status")
            .getter(getter(GetTableMaintenanceJobStatusResponse::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TableMaintenanceJobStatusValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableMaintenanceJobStatusValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tableARN;

    private final Map<String, TableMaintenanceJobStatusValue> status;

    private GetTableMaintenanceJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table.
     */
    public final String tableARN() {
        return tableARN;
    }

    /**
     * <p>
     * The status of the maintenance job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the maintenance job.
     */
    public final Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> status() {
        return TableMaintenanceJobStatusCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The status of the maintenance job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the maintenance job.
     */
    public final Map<String, TableMaintenanceJobStatusValue> statusAsStrings() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMaintenanceJobStatusResponse)) {
            return false;
        }
        GetTableMaintenanceJobStatusResponse other = (GetTableMaintenanceJobStatusResponse) obj;
        return Objects.equals(tableARN(), other.tableARN()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableMaintenanceJobStatusResponse").add("TableARN", tableARN())
                .add("Status", hasStatus() ? statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableARN":
            return Optional.ofNullable(clazz.cast(tableARN()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableMaintenanceJobStatusResponse, T> g) {
        return obj -> g.apply((GetTableMaintenanceJobStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3TablesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTableMaintenanceJobStatusResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table.
         * </p>
         * 
         * @param tableARN
         *        The Amazon Resource Name (ARN) of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableARN(String tableARN);

        /**
         * <p>
         * The status of the maintenance job.
         * </p>
         * 
         * @param status
         *        The status of the maintenance job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Map<String, TableMaintenanceJobStatusValue> status);

        /**
         * <p>
         * The status of the maintenance job.
         * </p>
         * 
         * @param status
         *        The status of the maintenance job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> status);
    }

    static final class BuilderImpl extends S3TablesResponse.BuilderImpl implements Builder {
        private String tableARN;

        private Map<String, TableMaintenanceJobStatusValue> status = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMaintenanceJobStatusResponse model) {
            super(model);
            tableARN(model.tableARN);
            statusWithStrings(model.status);
        }

        public final String getTableARN() {
            return tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Map<String, TableMaintenanceJobStatusValue.Builder> getStatus() {
            Map<String, TableMaintenanceJobStatusValue.Builder> result = TableMaintenanceJobStatusCopier
                    .copyToBuilder(this.status);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setStatus(Map<String, TableMaintenanceJobStatusValue.BuilderImpl> status) {
            this.status = TableMaintenanceJobStatusCopier.copyFromBuilder(status);
        }

        @Override
        public final Builder statusWithStrings(Map<String, TableMaintenanceJobStatusValue> status) {
            this.status = TableMaintenanceJobStatusCopier.copy(status);
            return this;
        }

        @Override
        public final Builder status(Map<TableMaintenanceJobType, TableMaintenanceJobStatusValue> status) {
            this.status = TableMaintenanceJobStatusCopier.copyEnumToString(status);
            return this;
        }

        @Override
        public GetTableMaintenanceJobStatusResponse build() {
            return new GetTableMaintenanceJobStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
