/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3tables.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the maintenance settings for the table bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableBucketMaintenanceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TableBucketMaintenanceSettings.Builder, TableBucketMaintenanceSettings> {
    private static final SdkField<IcebergUnreferencedFileRemovalSettings> ICEBERG_UNREFERENCED_FILE_REMOVAL_FIELD = SdkField
            .<IcebergUnreferencedFileRemovalSettings> builder(MarshallingType.SDK_POJO)
            .memberName("icebergUnreferencedFileRemoval")
            .getter(getter(TableBucketMaintenanceSettings::icebergUnreferencedFileRemoval))
            .setter(setter(Builder::icebergUnreferencedFileRemoval))
            .constructor(IcebergUnreferencedFileRemovalSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("icebergUnreferencedFileRemoval")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ICEBERG_UNREFERENCED_FILE_REMOVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval;

    private final Type type;

    private TableBucketMaintenanceSettings(BuilderImpl builder) {
        this.icebergUnreferencedFileRemoval = builder.icebergUnreferencedFileRemoval;
        this.type = builder.type;
    }

    /**
     * <p>
     * The unreferenced file removal settings for the table bucket.
     * </p>
     * 
     * @return The unreferenced file removal settings for the table bucket.
     */
    public final IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval() {
        return icebergUnreferencedFileRemoval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(icebergUnreferencedFileRemoval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableBucketMaintenanceSettings)) {
            return false;
        }
        TableBucketMaintenanceSettings other = (TableBucketMaintenanceSettings) obj;
        return Objects.equals(icebergUnreferencedFileRemoval(), other.icebergUnreferencedFileRemoval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableBucketMaintenanceSettings")
                .add("IcebergUnreferencedFileRemoval", icebergUnreferencedFileRemoval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "icebergUnreferencedFileRemoval":
            return Optional.ofNullable(clazz.cast(icebergUnreferencedFileRemoval()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #icebergUnreferencedFileRemoval()} initialized to the given value.
     *
     * <p>
     * The unreferenced file removal settings for the table bucket.
     * </p>
     * 
     * @param icebergUnreferencedFileRemoval
     *        The unreferenced file removal settings for the table bucket.
     */
    public static TableBucketMaintenanceSettings fromIcebergUnreferencedFileRemoval(
            IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval) {
        return builder().icebergUnreferencedFileRemoval(icebergUnreferencedFileRemoval).build();
    }

    /**
     * Create an instance of this class with {@link #icebergUnreferencedFileRemoval()} initialized to the given value.
     *
     * <p>
     * The unreferenced file removal settings for the table bucket.
     * </p>
     * 
     * @param icebergUnreferencedFileRemoval
     *        The unreferenced file removal settings for the table bucket.
     */
    public static TableBucketMaintenanceSettings fromIcebergUnreferencedFileRemoval(
            Consumer<IcebergUnreferencedFileRemovalSettings.Builder> icebergUnreferencedFileRemoval) {
        IcebergUnreferencedFileRemovalSettings.Builder builder = IcebergUnreferencedFileRemovalSettings.builder();
        icebergUnreferencedFileRemoval.accept(builder);
        return fromIcebergUnreferencedFileRemoval(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("icebergUnreferencedFileRemoval", ICEBERG_UNREFERENCED_FILE_REMOVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableBucketMaintenanceSettings, T> g) {
        return obj -> g.apply((TableBucketMaintenanceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableBucketMaintenanceSettings> {
        /**
         * <p>
         * The unreferenced file removal settings for the table bucket.
         * </p>
         * 
         * @param icebergUnreferencedFileRemoval
         *        The unreferenced file removal settings for the table bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergUnreferencedFileRemoval(IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval);

        /**
         * <p>
         * The unreferenced file removal settings for the table bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IcebergUnreferencedFileRemovalSettings.Builder} avoiding the need to create one manually via
         * {@link IcebergUnreferencedFileRemovalSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergUnreferencedFileRemovalSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #icebergUnreferencedFileRemoval(IcebergUnreferencedFileRemovalSettings)}.
         * 
         * @param icebergUnreferencedFileRemoval
         *        a consumer that will call methods on {@link IcebergUnreferencedFileRemovalSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergUnreferencedFileRemoval(IcebergUnreferencedFileRemovalSettings)
         */
        default Builder icebergUnreferencedFileRemoval(
                Consumer<IcebergUnreferencedFileRemovalSettings.Builder> icebergUnreferencedFileRemoval) {
            return icebergUnreferencedFileRemoval(IcebergUnreferencedFileRemovalSettings.builder()
                    .applyMutation(icebergUnreferencedFileRemoval).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableBucketMaintenanceSettings model) {
            icebergUnreferencedFileRemoval(model.icebergUnreferencedFileRemoval);
        }

        public final IcebergUnreferencedFileRemovalSettings.Builder getIcebergUnreferencedFileRemoval() {
            return icebergUnreferencedFileRemoval != null ? icebergUnreferencedFileRemoval.toBuilder() : null;
        }

        public final void setIcebergUnreferencedFileRemoval(
                IcebergUnreferencedFileRemovalSettings.BuilderImpl icebergUnreferencedFileRemoval) {
            Object oldValue = this.icebergUnreferencedFileRemoval;
            this.icebergUnreferencedFileRemoval = icebergUnreferencedFileRemoval != null ? icebergUnreferencedFileRemoval.build()
                    : null;
            handleUnionValueChange(Type.ICEBERG_UNREFERENCED_FILE_REMOVAL, oldValue, this.icebergUnreferencedFileRemoval);
        }

        @Override
        public final Builder icebergUnreferencedFileRemoval(IcebergUnreferencedFileRemovalSettings icebergUnreferencedFileRemoval) {
            Object oldValue = this.icebergUnreferencedFileRemoval;
            this.icebergUnreferencedFileRemoval = icebergUnreferencedFileRemoval;
            handleUnionValueChange(Type.ICEBERG_UNREFERENCED_FILE_REMOVAL, oldValue, this.icebergUnreferencedFileRemoval);
            return this;
        }

        @Override
        public TableBucketMaintenanceSettings build() {
            return new TableBucketMaintenanceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableBucketMaintenanceSettings#type()
     */
    public enum Type {
        ICEBERG_UNREFERENCED_FILE_REMOVAL,

        UNKNOWN_TO_SDK_VERSION
    }
}
