/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetScheduleGroupResponse extends SchedulerResponse implements
        ToCopyableBuilder<GetScheduleGroupResponse.Builder, GetScheduleGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetScheduleGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(GetScheduleGroupResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationDate").getter(getter(GetScheduleGroupResponse::lastModificationDate))
            .setter(setter(Builder::lastModificationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationDate").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetScheduleGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetScheduleGroupResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFICATION_DATE_FIELD, NAME_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant creationDate;

    private final Instant lastModificationDate;

    private final String name;

    private final String state;

    private GetScheduleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationDate = builder.creationDate;
        this.lastModificationDate = builder.lastModificationDate;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The time at which the schedule group was created.
     * </p>
     * 
     * @return The time at which the schedule group was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The time at which the schedule group was last modified.
     * </p>
     * 
     * @return The time at which the schedule group was last modified.
     */
    public final Instant lastModificationDate() {
        return lastModificationDate;
    }

    /**
     * <p>
     * The name of the schedule group.
     * </p>
     * 
     * @return The name of the schedule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the state of the schedule group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies the state of the schedule group.
     * @see ScheduleGroupState
     */
    public final ScheduleGroupState state() {
        return ScheduleGroupState.fromValue(state);
    }

    /**
     * <p>
     * Specifies the state of the schedule group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies the state of the schedule group.
     * @see ScheduleGroupState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetScheduleGroupResponse)) {
            return false;
        }
        GetScheduleGroupResponse other = (GetScheduleGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModificationDate(), other.lastModificationDate()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetScheduleGroupResponse").add("Arn", arn()).add("CreationDate", creationDate())
                .add("LastModificationDate", lastModificationDate()).add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModificationDate":
            return Optional.ofNullable(clazz.cast(lastModificationDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastModificationDate", LAST_MODIFICATION_DATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetScheduleGroupResponse, T> g) {
        return obj -> g.apply((GetScheduleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetScheduleGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the schedule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The time at which the schedule group was created.
         * </p>
         * 
         * @param creationDate
         *        The time at which the schedule group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The time at which the schedule group was last modified.
         * </p>
         * 
         * @param lastModificationDate
         *        The time at which the schedule group was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationDate(Instant lastModificationDate);

        /**
         * <p>
         * The name of the schedule group.
         * </p>
         * 
         * @param name
         *        The name of the schedule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the state of the schedule group.
         * </p>
         * 
         * @param state
         *        Specifies the state of the schedule group.
         * @see ScheduleGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies the state of the schedule group.
         * </p>
         * 
         * @param state
         *        Specifies the state of the schedule group.
         * @see ScheduleGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleGroupState
         */
        Builder state(ScheduleGroupState state);
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationDate;

        private Instant lastModificationDate;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetScheduleGroupResponse model) {
            super(model);
            arn(model.arn);
            creationDate(model.creationDate);
            lastModificationDate(model.lastModificationDate);
            name(model.name);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModificationDate() {
            return lastModificationDate;
        }

        public final void setLastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
        }

        @Override
        public final Builder lastModificationDate(Instant lastModificationDate) {
            this.lastModificationDate = lastModificationDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public GetScheduleGroupResponse build() {
            return new GetScheduleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
