/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemasRequest extends SchemasRequest implements
        ToCopyableBuilder<ListSchemasRequest.Builder, ListSchemasRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListSchemasRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemasRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(ListSchemasRequest::registryName)).setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaNamePrefix").getter(getter(ListSchemasRequest::schemaNamePrefix))
            .setter(setter(Builder::schemaNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("schemaNamePrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, NEXT_TOKEN_FIELD,
            REGISTRY_NAME_FIELD, SCHEMA_NAME_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer limit;

    private final String nextToken;

    private final String registryName;

    private final String schemaNamePrefix;

    private ListSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.registryName = builder.registryName;
        this.schemaNamePrefix = builder.schemaNamePrefix;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * Specifying this limits the results to only those schema names that start with the specified prefix.
     * </p>
     * 
     * @return Specifying this limits the results to only those schema names that start with the specified prefix.
     */
    public final String schemaNamePrefix() {
        return schemaNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaNamePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasRequest)) {
            return false;
        }
        ListSchemasRequest other = (ListSchemasRequest) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(registryName(), other.registryName())
                && Objects.equals(schemaNamePrefix(), other.schemaNamePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemasRequest").add("Limit", limit()).add("NextToken", nextToken())
                .add("RegistryName", registryName()).add("SchemaNamePrefix", schemaNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaNamePrefix":
            return Optional.ofNullable(clazz.cast(schemaNamePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("limit", LIMIT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("registryName", REGISTRY_NAME_FIELD);
        map.put("schemaNamePrefix", SCHEMA_NAME_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasRequest, T> g) {
        return obj -> g.apply((ListSchemasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemasRequest> {
        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * Specifying this limits the results to only those schema names that start with the specified prefix.
         * </p>
         * 
         * @param schemaNamePrefix
         *        Specifying this limits the results to only those schema names that start with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaNamePrefix(String schemaNamePrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchemasRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String nextToken;

        private String registryName;

        private String schemaNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasRequest model) {
            super(model);
            limit(model.limit);
            nextToken(model.nextToken);
            registryName(model.registryName);
            schemaNamePrefix(model.schemaNamePrefix);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaNamePrefix() {
            return schemaNamePrefix;
        }

        public final void setSchemaNamePrefix(String schemaNamePrefix) {
            this.schemaNamePrefix = schemaNamePrefix;
        }

        @Override
        public final Builder schemaNamePrefix(String schemaNamePrefix) {
            this.schemaNamePrefix = schemaNamePrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchemasRequest build() {
            return new ListSchemasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
