/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDiscovererResponse extends SchemasResponse implements
        ToCopyableBuilder<StartDiscovererResponse.Builder, StartDiscovererResponse> {
    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscovererId").getter(getter(StartDiscovererResponse::discovererId))
            .setter(setter(Builder::discovererId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StartDiscovererResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ID_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String discovererId;

    private final String state;

    private StartDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.discovererId = builder.discovererId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID of the discoverer.
     * </p>
     * 
     * @return The ID of the discoverer.
     */
    public final String discovererId() {
        return discovererId;
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public final DiscovererState state() {
        return DiscovererState.fromValue(state);
    }

    /**
     * <p>
     * The state of the discoverer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiscovererState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the discoverer.
     * @see DiscovererState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDiscovererResponse)) {
            return false;
        }
        StartDiscovererResponse other = (StartDiscovererResponse) obj;
        return Objects.equals(discovererId(), other.discovererId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDiscovererResponse").add("DiscovererId", discovererId()).add("State", stateAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DiscovererId":
            return Optional.ofNullable(clazz.cast(discovererId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DiscovererId", DISCOVERER_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDiscovererResponse, T> g) {
        return obj -> g.apply((StartDiscovererResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartDiscovererResponse> {
        /**
         * <p>
         * The ID of the discoverer.
         * </p>
         * 
         * @param discovererId
         *        The ID of the discoverer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discovererId(String discovererId);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the discoverer.
         * </p>
         * 
         * @param state
         *        The state of the discoverer.
         * @see DiscovererState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscovererState
         */
        Builder state(DiscovererState state);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String discovererId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDiscovererResponse model) {
            super(model);
            discovererId(model.discovererId);
            state(model.state);
        }

        public final String getDiscovererId() {
            return discovererId;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StartDiscovererResponse build() {
            return new StartDiscovererResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
