/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.auth.scheme;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securitylake.auth.scheme.internal.DefaultSecurityLakeAuthSchemeParams;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve the auth schemes for the SecurityLake service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface SecurityLakeAuthSchemeParams extends
        ToCopyableBuilder<SecurityLakeAuthSchemeParams.Builder, SecurityLakeAuthSchemeParams> {
    /**
     * Get a new builder for creating a {@link SecurityLakeAuthSchemeParams}.
     */
    static Builder builder() {
        return DefaultSecurityLakeAuthSchemeParams.builder();
    }

    /**
     * Returns the operation for which to resolve the auth scheme.
     */
    String operation();

    /**
     * Returns the region. The region parameter may be used with the "aws.auth#sigv4" auth scheme.
     */
    Region region();

    /**
     * Returns a {@link Builder} to customize the parameters.
     */
    Builder toBuilder();

    /**
     * A builder for a {@link SecurityLakeAuthSchemeParams}.
     */
    interface Builder extends CopyableBuilder<Builder, SecurityLakeAuthSchemeParams> {
        /**
         * Set the operation for which to resolve the auth scheme.
         */
        Builder operation(String operation);

        /**
         * Set the region. The region parameter may be used with the "aws.auth#sigv4" auth scheme.
         */
        Builder region(Region region);

        /**
         * Returns a {@link SecurityLakeAuthSchemeParams} object that is created from the properties that have been set
         * on the builder.
         */
        SecurityLakeAuthSchemeParams build();
    }
}
