/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataLakeRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateDataLakeRequest.Builder, CreateDataLakeRequest> {
    private static final SdkField<List<DataLakeConfiguration>> CONFIGURATIONS_FIELD = SdkField
            .<List<DataLakeConfiguration>> builder(MarshallingType.LIST)
            .memberName("configurations")
            .getter(getter(CreateDataLakeRequest::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> META_STORE_MANAGER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metaStoreManagerRoleArn").getter(getter(CreateDataLakeRequest::metaStoreManagerRoleArn))
            .setter(setter(Builder::metaStoreManagerRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metaStoreManagerRoleArn").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDataLakeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD,
            META_STORE_MANAGER_ROLE_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataLakeConfiguration> configurations;

    private final String metaStoreManagerRoleArn;

    private final List<Tag> tags;

    private CreateDataLakeRequest(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
        this.metaStoreManagerRoleArn = builder.metaStoreManagerRoleArn;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specify the Region or Regions that will contribute data to the rollup region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Specify the Region or Regions that will contribute data to the rollup region.
     */
    public final List<DataLakeConfiguration> configurations() {
        return configurations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions generated
     * by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions
     *         generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.
     */
    public final String metaStoreManagerRoleArn() {
        return metaStoreManagerRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
     * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
     *         must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metaStoreManagerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataLakeRequest)) {
            return false;
        }
        CreateDataLakeRequest other = (CreateDataLakeRequest) obj;
        return hasConfigurations() == other.hasConfigurations() && Objects.equals(configurations(), other.configurations())
                && Objects.equals(metaStoreManagerRoleArn(), other.metaStoreManagerRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataLakeRequest").add("Configurations", hasConfigurations() ? configurations() : null)
                .add("MetaStoreManagerRoleArn", metaStoreManagerRoleArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        case "metaStoreManagerRoleArn":
            return Optional.ofNullable(clazz.cast(metaStoreManagerRoleArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurations", CONFIGURATIONS_FIELD);
        map.put("metaStoreManagerRoleArn", META_STORE_MANAGER_ROLE_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataLakeRequest, T> g) {
        return obj -> g.apply((CreateDataLakeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataLakeRequest> {
        /**
         * <p>
         * Specify the Region or Regions that will contribute data to the rollup region.
         * </p>
         * 
         * @param configurations
         *        Specify the Region or Regions that will contribute data to the rollup region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<DataLakeConfiguration> configurations);

        /**
         * <p>
         * Specify the Region or Regions that will contribute data to the rollup region.
         * </p>
         * 
         * @param configurations
         *        Specify the Region or Regions that will contribute data to the rollup region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(DataLakeConfiguration... configurations);

        /**
         * <p>
         * Specify the Region or Regions that will contribute data to the rollup region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configurations(List<DataLakeConfiguration>)}.
         * 
         * @param configurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.DataLakeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurations(java.util.Collection<DataLakeConfiguration>)
         */
        Builder configurations(Consumer<DataLakeConfiguration.Builder>... configurations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains partitions
         * generated by the ingestion and normalization of Amazon Web Services log sources and custom sources.
         * </p>
         * 
         * @param metaStoreManagerRoleArn
         *        The Amazon Resource Name (ARN) used to create and update the Glue table. This table contains
         *        partitions generated by the ingestion and normalization of Amazon Web Services log sources and custom
         *        sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
         * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * 
         * @param tags
         *        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
         *        must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
         * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * 
         * @param tags
         *        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you
         *        must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must
         * specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securitylake.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<DataLakeConfiguration> configurations = DefaultSdkAutoConstructList.getInstance();

        private String metaStoreManagerRoleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataLakeRequest model) {
            super(model);
            configurations(model.configurations);
            metaStoreManagerRoleArn(model.metaStoreManagerRoleArn);
            tags(model.tags);
        }

        public final List<DataLakeConfiguration.Builder> getConfigurations() {
            List<DataLakeConfiguration.Builder> result = DataLakeConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<DataLakeConfiguration.BuilderImpl> configurations) {
            this.configurations = DataLakeConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<DataLakeConfiguration> configurations) {
            this.configurations = DataLakeConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(DataLakeConfiguration... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<DataLakeConfiguration.Builder>... configurations) {
            configurations(Stream.of(configurations).map(c -> DataLakeConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMetaStoreManagerRoleArn() {
            return metaStoreManagerRoleArn;
        }

        public final void setMetaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
        }

        @Override
        public final Builder metaStoreManagerRoleArn(String metaStoreManagerRoleArn) {
            this.metaStoreManagerRoleArn = metaStoreManagerRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataLakeRequest build() {
            return new CreateDataLakeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
