/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Automatically enable new organization accounts as member accounts from an Amazon Security Lake administrator account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeAutoEnableNewAccountConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeAutoEnableNewAccountConfiguration.Builder, DataLakeAutoEnableNewAccountConfiguration> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(DataLakeAutoEnableNewAccountConfiguration::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<AwsLogSourceResource>> SOURCES_FIELD = SdkField
            .<List<AwsLogSourceResource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(DataLakeAutoEnableNewAccountConfiguration::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsLogSourceResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsLogSourceResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final List<AwsLogSourceResource> sources;

    private DataLakeAutoEnableNewAccountConfiguration(BuilderImpl builder) {
        this.region = builder.region;
        this.sources = builder.sources;
    }

    /**
     * <p>
     * The Amazon Web Services Regions where Security Lake is automatically enabled.
     * </p>
     * 
     * @return The Amazon Web Services Regions where Security Lake is automatically enabled.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services sources that are automatically enabled in Security Lake.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The Amazon Web Services sources that are automatically enabled in Security Lake.
     */
    public final List<AwsLogSourceResource> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAutoEnableNewAccountConfiguration)) {
            return false;
        }
        DataLakeAutoEnableNewAccountConfiguration other = (DataLakeAutoEnableNewAccountConfiguration) obj;
        return Objects.equals(region(), other.region()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeAutoEnableNewAccountConfiguration").add("Region", region())
                .add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("region", REGION_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAutoEnableNewAccountConfiguration, T> g) {
        return obj -> g.apply((DataLakeAutoEnableNewAccountConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeAutoEnableNewAccountConfiguration> {
        /**
         * <p>
         * The Amazon Web Services Regions where Security Lake is automatically enabled.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions where Security Lake is automatically enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Amazon Web Services sources that are automatically enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources that are automatically enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<AwsLogSourceResource> sources);

        /**
         * <p>
         * The Amazon Web Services sources that are automatically enabled in Security Lake.
         * </p>
         * 
         * @param sources
         *        The Amazon Web Services sources that are automatically enabled in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(AwsLogSourceResource... sources);

        /**
         * <p>
         * The Amazon Web Services sources that are automatically enabled in Security Lake.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<AwsLogSourceResource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.AwsLogSourceResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<AwsLogSourceResource>)
         */
        Builder sources(Consumer<AwsLogSourceResource.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private List<AwsLogSourceResource> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAutoEnableNewAccountConfiguration model) {
            region(model.region);
            sources(model.sources);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<AwsLogSourceResource.Builder> getSources() {
            List<AwsLogSourceResource.Builder> result = AwsLogSourceResourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<AwsLogSourceResource.BuilderImpl> sources) {
            this.sources = AwsLogSourceResourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<AwsLogSourceResource> sources) {
            this.sources = AwsLogSourceResourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(AwsLogSourceResource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<AwsLogSourceResource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> AwsLogSourceResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataLakeAutoEnableNewAccountConfiguration build() {
            return new DataLakeAutoEnableNewAccountConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
