/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details of Amazon Security Lake object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeConfiguration.Builder, DataLakeConfiguration> {
    private static final SdkField<DataLakeEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<DataLakeEncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(DataLakeConfiguration::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(DataLakeEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<DataLakeLifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField
            .<DataLakeLifecycleConfiguration> builder(MarshallingType.SDK_POJO).memberName("lifecycleConfiguration")
            .getter(getter(DataLakeConfiguration::lifecycleConfiguration)).setter(setter(Builder::lifecycleConfiguration))
            .constructor(DataLakeLifecycleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(DataLakeConfiguration::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<DataLakeReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField
            .<DataLakeReplicationConfiguration> builder(MarshallingType.SDK_POJO).memberName("replicationConfiguration")
            .getter(getter(DataLakeConfiguration::replicationConfiguration)).setter(setter(Builder::replicationConfiguration))
            .constructor(DataLakeReplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENCRYPTION_CONFIGURATION_FIELD, LIFECYCLE_CONFIGURATION_FIELD, REGION_FIELD, REPLICATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataLakeEncryptionConfiguration encryptionConfiguration;

    private final DataLakeLifecycleConfiguration lifecycleConfiguration;

    private final String region;

    private final DataLakeReplicationConfiguration replicationConfiguration;

    private DataLakeConfiguration(BuilderImpl builder) {
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.region = builder.region;
        this.replicationConfiguration = builder.replicationConfiguration;
    }

    /**
     * <p>
     * Provides encryption details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides encryption details of Amazon Security Lake object.
     */
    public final DataLakeEncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * Provides lifecycle details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides lifecycle details of Amazon Security Lake object.
     */
    public final DataLakeLifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    /**
     * <p>
     * The Amazon Web Services Regions where Security Lake is automatically enabled.
     * </p>
     * 
     * @return The Amazon Web Services Regions where Security Lake is automatically enabled.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * Provides replication details of Amazon Security Lake object.
     * </p>
     * 
     * @return Provides replication details of Amazon Security Lake object.
     */
    public final DataLakeReplicationConfiguration replicationConfiguration() {
        return replicationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeConfiguration)) {
            return false;
        }
        DataLakeConfiguration other = (DataLakeConfiguration) obj;
        return Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(lifecycleConfiguration(), other.lifecycleConfiguration())
                && Objects.equals(region(), other.region())
                && Objects.equals(replicationConfiguration(), other.replicationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeConfiguration").add("EncryptionConfiguration", encryptionConfiguration())
                .add("LifecycleConfiguration", lifecycleConfiguration()).add("Region", region())
                .add("ReplicationConfiguration", replicationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "lifecycleConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleConfiguration()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "replicationConfiguration":
            return Optional.ofNullable(clazz.cast(replicationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("lifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("replicationConfiguration", REPLICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeConfiguration, T> g) {
        return obj -> g.apply((DataLakeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeConfiguration> {
        /**
         * <p>
         * Provides encryption details of Amazon Security Lake object.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Provides encryption details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * Provides encryption details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeEncryptionConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #encryptionConfiguration(DataLakeEncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link DataLakeEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(DataLakeEncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<DataLakeEncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(DataLakeEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)
                    .build());
        }

        /**
         * <p>
         * Provides lifecycle details of Amazon Security Lake object.
         * </p>
         * 
         * @param lifecycleConfiguration
         *        Provides lifecycle details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration);

        /**
         * <p>
         * Provides lifecycle details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeLifecycleConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeLifecycleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeLifecycleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleConfiguration(DataLakeLifecycleConfiguration)}.
         * 
         * @param lifecycleConfiguration
         *        a consumer that will call methods on {@link DataLakeLifecycleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleConfiguration(DataLakeLifecycleConfiguration)
         */
        default Builder lifecycleConfiguration(Consumer<DataLakeLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return lifecycleConfiguration(DataLakeLifecycleConfiguration.builder().applyMutation(lifecycleConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Web Services Regions where Security Lake is automatically enabled.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions where Security Lake is automatically enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Provides replication details of Amazon Security Lake object.
         * </p>
         * 
         * @param replicationConfiguration
         *        Provides replication details of Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration);

        /**
         * <p>
         * Provides replication details of Amazon Security Lake object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakeReplicationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataLakeReplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakeReplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #replicationConfiguration(DataLakeReplicationConfiguration)}.
         * 
         * @param replicationConfiguration
         *        a consumer that will call methods on {@link DataLakeReplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationConfiguration(DataLakeReplicationConfiguration)
         */
        default Builder replicationConfiguration(Consumer<DataLakeReplicationConfiguration.Builder> replicationConfiguration) {
            return replicationConfiguration(DataLakeReplicationConfiguration.builder().applyMutation(replicationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataLakeEncryptionConfiguration encryptionConfiguration;

        private DataLakeLifecycleConfiguration lifecycleConfiguration;

        private String region;

        private DataLakeReplicationConfiguration replicationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeConfiguration model) {
            encryptionConfiguration(model.encryptionConfiguration);
            lifecycleConfiguration(model.lifecycleConfiguration);
            region(model.region);
            replicationConfiguration(model.replicationConfiguration);
        }

        public final DataLakeEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(DataLakeEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(DataLakeEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final DataLakeLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(DataLakeLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(DataLakeLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final DataLakeReplicationConfiguration.Builder getReplicationConfiguration() {
            return replicationConfiguration != null ? replicationConfiguration.toBuilder() : null;
        }

        public final void setReplicationConfiguration(DataLakeReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public final Builder replicationConfiguration(DataLakeReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        @Override
        public DataLakeConfiguration build() {
            return new DataLakeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
