/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSubscriberResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<UpdateSubscriberResponse.Builder, UpdateSubscriberResponse> {
    private static final SdkField<SubscriberResource> SUBSCRIBER_FIELD = SdkField
            .<SubscriberResource> builder(MarshallingType.SDK_POJO).memberName("subscriber")
            .getter(getter(UpdateSubscriberResponse::subscriber)).setter(setter(Builder::subscriber))
            .constructor(SubscriberResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SubscriberResource subscriber;

    private UpdateSubscriberResponse(BuilderImpl builder) {
        super(builder);
        this.subscriber = builder.subscriber;
    }

    /**
     * <p>
     * The updated subscriber information.
     * </p>
     * 
     * @return The updated subscriber information.
     */
    public final SubscriberResource subscriber() {
        return subscriber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberResponse)) {
            return false;
        }
        UpdateSubscriberResponse other = (UpdateSubscriberResponse) obj;
        return Objects.equals(subscriber(), other.subscriber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSubscriberResponse").add("Subscriber", subscriber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriber":
            return Optional.ofNullable(clazz.cast(subscriber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("subscriber", SUBSCRIBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriberResponse, T> g) {
        return obj -> g.apply((UpdateSubscriberResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSubscriberResponse> {
        /**
         * <p>
         * The updated subscriber information.
         * </p>
         * 
         * @param subscriber
         *        The updated subscriber information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriber(SubscriberResource subscriber);

        /**
         * <p>
         * The updated subscriber information.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubscriberResource.Builder} avoiding the
         * need to create one manually via {@link SubscriberResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubscriberResource.Builder#build()} is called immediately and its
         * result is passed to {@link #subscriber(SubscriberResource)}.
         * 
         * @param subscriber
         *        a consumer that will call methods on {@link SubscriberResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriber(SubscriberResource)
         */
        default Builder subscriber(Consumer<SubscriberResource.Builder> subscriber) {
            return subscriber(SubscriberResource.builder().applyMutation(subscriber).build());
        }
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private SubscriberResource subscriber;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriberResponse model) {
            super(model);
            subscriber(model.subscriber);
        }

        public final SubscriberResource.Builder getSubscriber() {
            return subscriber != null ? subscriber.toBuilder() : null;
        }

        public final void setSubscriber(SubscriberResource.BuilderImpl subscriber) {
            this.subscriber = subscriber != null ? subscriber.build() : null;
        }

        @Override
        public final Builder subscriber(SubscriberResource subscriber) {
            this.subscriber = subscriber;
            return this;
        }

        @Override
        public UpdateSubscriberResponse build() {
            return new UpdateSubscriberResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
