/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageDsn
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageDsn> {
    private static final SdkField<String> REPORTING_MTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportingMta").getter(MessageDsn.getter(MessageDsn::reportingMta)).setter(MessageDsn.setter(Builder::reportingMta)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportingMta").build()}).build();
    private static final SdkField<Instant> ARRIVAL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ArrivalDate").getter(MessageDsn.getter(MessageDsn::arrivalDate)).setter(MessageDsn.setter(Builder::arrivalDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrivalDate").build()}).build();
    private static final SdkField<List<ExtensionField>> EXTENSION_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExtensionFields").getter(MessageDsn.getter(MessageDsn::extensionFields)).setter(MessageDsn.setter(Builder::extensionFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExtensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORTING_MTA_FIELD, ARRIVAL_DATE_FIELD, EXTENSION_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageDsn.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reportingMta;
    private final Instant arrivalDate;
    private final List<ExtensionField> extensionFields;

    private MessageDsn(BuilderImpl builder) {
        this.reportingMta = builder.reportingMta;
        this.arrivalDate = builder.arrivalDate;
        this.extensionFields = builder.extensionFields;
    }

    public final String reportingMta() {
        return this.reportingMta;
    }

    public final Instant arrivalDate() {
        return this.arrivalDate;
    }

    public final boolean hasExtensionFields() {
        return this.extensionFields != null && !(this.extensionFields instanceof SdkAutoConstructList);
    }

    public final List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportingMta());
        hashCode = 31 * hashCode + Objects.hashCode(this.arrivalDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtensionFields() ? this.extensionFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDsn)) {
            return false;
        }
        MessageDsn other = (MessageDsn)obj;
        return Objects.equals(this.reportingMta(), other.reportingMta()) && Objects.equals(this.arrivalDate(), other.arrivalDate()) && this.hasExtensionFields() == other.hasExtensionFields() && Objects.equals(this.extensionFields(), other.extensionFields());
    }

    public final String toString() {
        return ToString.builder((String)"MessageDsn").add("ReportingMta", (Object)this.reportingMta()).add("ArrivalDate", (Object)this.arrivalDate()).add("ExtensionFields", this.hasExtensionFields() ? this.extensionFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportingMta": {
                return Optional.ofNullable(clazz.cast(this.reportingMta()));
            }
            case "ArrivalDate": {
                return Optional.ofNullable(clazz.cast(this.arrivalDate()));
            }
            case "ExtensionFields": {
                return Optional.ofNullable(clazz.cast(this.extensionFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportingMta", REPORTING_MTA_FIELD);
        map.put("ArrivalDate", ARRIVAL_DATE_FIELD);
        map.put("ExtensionFields", EXTENSION_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageDsn, T> g) {
        return obj -> g.apply((MessageDsn)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportingMta;
        private Instant arrivalDate;
        private List<ExtensionField> extensionFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageDsn model) {
            this.reportingMta(model.reportingMta);
            this.arrivalDate(model.arrivalDate);
            this.extensionFields(model.extensionFields);
        }

        public final String getReportingMta() {
            return this.reportingMta;
        }

        public final void setReportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
        }

        @Override
        public final Builder reportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
            return this;
        }

        public final Instant getArrivalDate() {
            return this.arrivalDate;
        }

        public final void setArrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
        }

        @Override
        public final Builder arrivalDate(Instant arrivalDate) {
            this.arrivalDate = arrivalDate;
            return this;
        }

        public final List<ExtensionField.Builder> getExtensionFields() {
            List<ExtensionField.Builder> result = ExtensionFieldListCopier.copyToBuilder(this.extensionFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            this.extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(Consumer<ExtensionField.Builder> ... extensionFields) {
            this.extensionFields(Stream.of(extensionFields).map(c -> (ExtensionField)((ExtensionField.Builder)ExtensionField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MessageDsn build() {
            return new MessageDsn(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageDsn> {
        public Builder reportingMta(String var1);

        public Builder arrivalDate(Instant var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);

        public Builder extensionFields(Consumer<ExtensionField.Builder> ... var1);
    }
}

