/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMapRunRequest extends SfnRequest implements
        ToCopyableBuilder<UpdateMapRunRequest.Builder, UpdateMapRunRequest> {
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mapRunArn").getter(getter(UpdateMapRunRequest::mapRunArn)).setter(setter(Builder::mapRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrency").getter(getter(UpdateMapRunRequest::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrency").build()).build();

    private static final SdkField<Float> TOLERATED_FAILURE_PERCENTAGE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("toleratedFailurePercentage")
            .getter(getter(UpdateMapRunRequest::toleratedFailurePercentage))
            .setter(setter(Builder::toleratedFailurePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailurePercentage").build())
            .build();

    private static final SdkField<Long> TOLERATED_FAILURE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("toleratedFailureCount").getter(getter(UpdateMapRunRequest::toleratedFailureCount))
            .setter(setter(Builder::toleratedFailureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toleratedFailureCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAP_RUN_ARN_FIELD,
            MAX_CONCURRENCY_FIELD, TOLERATED_FAILURE_PERCENTAGE_FIELD, TOLERATED_FAILURE_COUNT_FIELD));

    private final String mapRunArn;

    private final Integer maxConcurrency;

    private final Float toleratedFailurePercentage;

    private final Long toleratedFailureCount;

    private UpdateMapRunRequest(BuilderImpl builder) {
        super(builder);
        this.mapRunArn = builder.mapRunArn;
        this.maxConcurrency = builder.maxConcurrency;
        this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
        this.toleratedFailureCount = builder.toleratedFailureCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Map Run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Map Run.
     */
    public final String mapRunArn() {
        return mapRunArn;
    }

    /**
     * <p>
     * The maximum number of child workflow executions that can be specified to run in parallel for the Map Run at the
     * same time.
     * </p>
     * 
     * @return The maximum number of child workflow executions that can be specified to run in parallel for the Map Run
     *         at the same time.
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum percentage of failed items before the Map Run fails.
     * </p>
     * 
     * @return The maximum percentage of failed items before the Map Run fails.
     */
    public final Float toleratedFailurePercentage() {
        return toleratedFailurePercentage;
    }

    /**
     * <p>
     * The maximum number of failed items before the Map Run fails.
     * </p>
     * 
     * @return The maximum number of failed items before the Map Run fails.
     */
    public final Long toleratedFailureCount() {
        return toleratedFailureCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(toleratedFailurePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(toleratedFailureCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMapRunRequest)) {
            return false;
        }
        UpdateMapRunRequest other = (UpdateMapRunRequest) obj;
        return Objects.equals(mapRunArn(), other.mapRunArn()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(toleratedFailurePercentage(), other.toleratedFailurePercentage())
                && Objects.equals(toleratedFailureCount(), other.toleratedFailureCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMapRunRequest").add("MapRunArn", mapRunArn()).add("MaxConcurrency", maxConcurrency())
                .add("ToleratedFailurePercentage", toleratedFailurePercentage())
                .add("ToleratedFailureCount", toleratedFailureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mapRunArn":
            return Optional.ofNullable(clazz.cast(mapRunArn()));
        case "maxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "toleratedFailurePercentage":
            return Optional.ofNullable(clazz.cast(toleratedFailurePercentage()));
        case "toleratedFailureCount":
            return Optional.ofNullable(clazz.cast(toleratedFailureCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMapRunRequest, T> g) {
        return obj -> g.apply((UpdateMapRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMapRunRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Map Run.
         * </p>
         * 
         * @param mapRunArn
         *        The Amazon Resource Name (ARN) of a Map Run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapRunArn(String mapRunArn);

        /**
         * <p>
         * The maximum number of child workflow executions that can be specified to run in parallel for the Map Run at
         * the same time.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of child workflow executions that can be specified to run in parallel for the Map
         *        Run at the same time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);

        /**
         * <p>
         * The maximum percentage of failed items before the Map Run fails.
         * </p>
         * 
         * @param toleratedFailurePercentage
         *        The maximum percentage of failed items before the Map Run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toleratedFailurePercentage(Float toleratedFailurePercentage);

        /**
         * <p>
         * The maximum number of failed items before the Map Run fails.
         * </p>
         * 
         * @param toleratedFailureCount
         *        The maximum number of failed items before the Map Run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toleratedFailureCount(Long toleratedFailureCount);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String mapRunArn;

        private Integer maxConcurrency;

        private Float toleratedFailurePercentage;

        private Long toleratedFailureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMapRunRequest model) {
            super(model);
            mapRunArn(model.mapRunArn);
            maxConcurrency(model.maxConcurrency);
            toleratedFailurePercentage(model.toleratedFailurePercentage);
            toleratedFailureCount(model.toleratedFailureCount);
        }

        public final String getMapRunArn() {
            return mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Float getToleratedFailurePercentage() {
            return toleratedFailurePercentage;
        }

        public final void setToleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
        }

        @Override
        public final Builder toleratedFailurePercentage(Float toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        public final Long getToleratedFailureCount() {
            return toleratedFailureCount;
        }

        public final void setToleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
        }

        @Override
        public final Builder toleratedFailureCount(Long toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMapRunRequest build() {
            return new UpdateMapRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
