/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.IncludedData;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStateMachineRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, DescribeStateMachineRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(DescribeStateMachineRequest.getter(DescribeStateMachineRequest::stateMachineArn)).setter(DescribeStateMachineRequest.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> INCLUDED_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("includedData").getter(DescribeStateMachineRequest.getter(DescribeStateMachineRequest::includedDataAsString)).setter(DescribeStateMachineRequest.setter(Builder::includedData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, INCLUDED_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
            this.put("includedData", INCLUDED_DATA_FIELD);
        }
    });
    private final String stateMachineArn;
    private final String includedData;

    private DescribeStateMachineRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.includedData = builder.includedData;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final IncludedData includedData() {
        return IncludedData.fromValue(this.includedData);
    }

    public final String includedDataAsString() {
        return this.includedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedDataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStateMachineRequest)) {
            return false;
        }
        DescribeStateMachineRequest other = (DescribeStateMachineRequest)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.includedDataAsString(), other.includedDataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStateMachineRequest").add("StateMachineArn", (Object)this.stateMachineArn()).add("IncludedData", (Object)this.includedDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "includedData": {
                return Optional.ofNullable(clazz.cast(this.includedDataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStateMachineRequest, T> g) {
        return obj -> g.apply((DescribeStateMachineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStateMachineRequest model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.includedData(model.includedData);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getIncludedData() {
            return this.includedData;
        }

        public final void setIncludedData(String includedData) {
            this.includedData = includedData;
        }

        @Override
        public final Builder includedData(String includedData) {
            this.includedData = includedData;
            return this;
        }

        @Override
        public final Builder includedData(IncludedData includedData) {
            this.includedData(includedData == null ? null : includedData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStateMachineRequest build() {
            return new DescribeStateMachineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStateMachineRequest> {
        public Builder stateMachineArn(String var1);

        public Builder includedData(String var1);

        public Builder includedData(IncludedData var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

