/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.ExecutionRedriveFilter;
import software.amazon.awssdk.services.sfn.model.ExecutionStatus;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutionsRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, ListExecutionsRequest> {
    private static final SdkField<String> STATE_MACHINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineArn").getter(ListExecutionsRequest.getter(ListExecutionsRequest::stateMachineArn)).setter(ListExecutionsRequest.setter(Builder::stateMachineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineArn").build()}).build();
    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusFilter").getter(ListExecutionsRequest.getter(ListExecutionsRequest::statusFilterAsString)).setter(ListExecutionsRequest.setter(Builder::statusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListExecutionsRequest.getter(ListExecutionsRequest::maxResults)).setter(ListExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExecutionsRequest.getter(ListExecutionsRequest::nextToken)).setter(ListExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> MAP_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mapRunArn").getter(ListExecutionsRequest.getter(ListExecutionsRequest::mapRunArn)).setter(ListExecutionsRequest.setter(Builder::mapRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapRunArn").build()}).build();
    private static final SdkField<String> REDRIVE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redriveFilter").getter(ListExecutionsRequest.getter(ListExecutionsRequest::redriveFilterAsString)).setter(ListExecutionsRequest.setter(Builder::redriveFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redriveFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ARN_FIELD, STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, MAP_RUN_ARN_FIELD, REDRIVE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stateMachineArn", STATE_MACHINE_ARN_FIELD);
            this.put("statusFilter", STATUS_FILTER_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("mapRunArn", MAP_RUN_ARN_FIELD);
            this.put("redriveFilter", REDRIVE_FILTER_FIELD);
        }
    });
    private final String stateMachineArn;
    private final String statusFilter;
    private final Integer maxResults;
    private final String nextToken;
    private final String mapRunArn;
    private final String redriveFilter;

    private ListExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineArn = builder.stateMachineArn;
        this.statusFilter = builder.statusFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.mapRunArn = builder.mapRunArn;
        this.redriveFilter = builder.redriveFilter;
    }

    public final String stateMachineArn() {
        return this.stateMachineArn;
    }

    public final ExecutionStatus statusFilter() {
        return ExecutionStatus.fromValue(this.statusFilter);
    }

    public final String statusFilterAsString() {
        return this.statusFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String mapRunArn() {
        return this.mapRunArn;
    }

    public final ExecutionRedriveFilter redriveFilter() {
        return ExecutionRedriveFilter.fromValue(this.redriveFilter);
    }

    public final String redriveFilterAsString() {
        return this.redriveFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.redriveFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsRequest)) {
            return false;
        }
        ListExecutionsRequest other = (ListExecutionsRequest)((Object)obj);
        return Objects.equals(this.stateMachineArn(), other.stateMachineArn()) && Objects.equals(this.statusFilterAsString(), other.statusFilterAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.mapRunArn(), other.mapRunArn()) && Objects.equals(this.redriveFilterAsString(), other.redriveFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListExecutionsRequest").add("StateMachineArn", (Object)this.stateMachineArn()).add("StatusFilter", (Object)this.statusFilterAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("MapRunArn", (Object)this.mapRunArn()).add("RedriveFilter", (Object)this.redriveFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineArn()));
            }
            case "statusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilterAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "mapRunArn": {
                return Optional.ofNullable(clazz.cast(this.mapRunArn()));
            }
            case "redriveFilter": {
                return Optional.ofNullable(clazz.cast(this.redriveFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsRequest, T> g) {
        return obj -> g.apply((ListExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineArn;
        private String statusFilter;
        private Integer maxResults;
        private String nextToken;
        private String mapRunArn;
        private String redriveFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsRequest model) {
            super(model);
            this.stateMachineArn(model.stateMachineArn);
            this.statusFilter(model.statusFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.mapRunArn(model.mapRunArn);
            this.redriveFilter(model.redriveFilter);
        }

        public final String getStateMachineArn() {
            return this.stateMachineArn;
        }

        public final void setStateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
        }

        @Override
        public final Builder stateMachineArn(String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(ExecutionStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getMapRunArn() {
            return this.mapRunArn;
        }

        public final void setMapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
        }

        @Override
        public final Builder mapRunArn(String mapRunArn) {
            this.mapRunArn = mapRunArn;
            return this;
        }

        public final String getRedriveFilter() {
            return this.redriveFilter;
        }

        public final void setRedriveFilter(String redriveFilter) {
            this.redriveFilter = redriveFilter;
        }

        @Override
        public final Builder redriveFilter(String redriveFilter) {
            this.redriveFilter = redriveFilter;
            return this;
        }

        @Override
        public final Builder redriveFilter(ExecutionRedriveFilter redriveFilter) {
            this.redriveFilter(redriveFilter == null ? null : redriveFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExecutionsRequest build() {
            return new ListExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutionsRequest> {
        public Builder stateMachineArn(String var1);

        public Builder statusFilter(String var1);

        public Builder statusFilter(ExecutionStatus var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder mapRunArn(String var1);

        public Builder redriveFilter(String var1);

        public Builder redriveFilter(ExecutionRedriveFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

