/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sfn.model.RoutingConfigurationListCopier;
import software.amazon.awssdk.services.sfn.model.RoutingConfigurationListItem;
import software.amazon.awssdk.services.sfn.model.SfnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStateMachineAliasRequest
extends SfnRequest
implements ToCopyableBuilder<Builder, UpdateStateMachineAliasRequest> {
    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateMachineAliasArn").getter(UpdateStateMachineAliasRequest.getter(UpdateStateMachineAliasRequest::stateMachineAliasArn)).setter(UpdateStateMachineAliasRequest.setter(Builder::stateMachineAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateStateMachineAliasRequest.getter(UpdateStateMachineAliasRequest::description)).setter(UpdateStateMachineAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<RoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(UpdateStateMachineAliasRequest.getter(UpdateStateMachineAliasRequest::routingConfiguration)).setter(UpdateStateMachineAliasRequest.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIAS_ARN_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        }
    });
    private final String stateMachineAliasArn;
    private final String description;
    private final List<RoutingConfigurationListItem> routingConfiguration;

    private UpdateStateMachineAliasRequest(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
    }

    public final String stateMachineAliasArn() {
        return this.stateMachineAliasArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<RoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineAliasRequest)) {
            return false;
        }
        UpdateStateMachineAliasRequest other = (UpdateStateMachineAliasRequest)((Object)obj);
        return Objects.equals(this.stateMachineAliasArn(), other.stateMachineAliasArn()) && Objects.equals(this.description(), other.description()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStateMachineAliasRequest").add("StateMachineAliasArn", (Object)this.stateMachineAliasArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateMachineAliasArn": {
                return Optional.ofNullable(clazz.cast(this.stateMachineAliasArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineAliasRequest, T> g) {
        return obj -> g.apply((UpdateStateMachineAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SfnRequest.BuilderImpl
    implements Builder {
        private String stateMachineAliasArn;
        private String description;
        private List<RoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineAliasRequest model) {
            super(model);
            this.stateMachineAliasArn(model.stateMachineAliasArn);
            this.description(model.description);
            this.routingConfiguration(model.routingConfiguration);
        }

        public final String getStateMachineAliasArn() {
            return this.stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<RoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<RoutingConfigurationListItem.Builder> result = RoutingConfigurationListCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<RoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<RoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = RoutingConfigurationListCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(RoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (RoutingConfigurationListItem)((RoutingConfigurationListItem.Builder)RoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStateMachineAliasRequest build() {
            return new UpdateStateMachineAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SfnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStateMachineAliasRequest> {
        public Builder stateMachineAliasArn(String var1);

        public Builder description(String var1);

        public Builder routingConfiguration(Collection<RoutingConfigurationListItem> var1);

        public Builder routingConfiguration(RoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<RoutingConfigurationListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

