/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sfn.model.ValidateStateMachineDefinitionSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateStateMachineDefinitionDiagnostic
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidateStateMachineDefinitionDiagnostic> {
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(ValidateStateMachineDefinitionDiagnostic.getter(ValidateStateMachineDefinitionDiagnostic::severityAsString)).setter(ValidateStateMachineDefinitionDiagnostic.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(ValidateStateMachineDefinitionDiagnostic.getter(ValidateStateMachineDefinitionDiagnostic::code)).setter(ValidateStateMachineDefinitionDiagnostic.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(ValidateStateMachineDefinitionDiagnostic.getter(ValidateStateMachineDefinitionDiagnostic::message)).setter(ValidateStateMachineDefinitionDiagnostic.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(ValidateStateMachineDefinitionDiagnostic.getter(ValidateStateMachineDefinitionDiagnostic::location)).setter(ValidateStateMachineDefinitionDiagnostic.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_FIELD, CODE_FIELD, MESSAGE_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("severity", SEVERITY_FIELD);
            this.put("code", CODE_FIELD);
            this.put("message", MESSAGE_FIELD);
            this.put("location", LOCATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String severity;
    private final String code;
    private final String message;
    private final String location;

    private ValidateStateMachineDefinitionDiagnostic(BuilderImpl builder) {
        this.severity = builder.severity;
        this.code = builder.code;
        this.message = builder.message;
        this.location = builder.location;
    }

    public final ValidateStateMachineDefinitionSeverity severity() {
        return ValidateStateMachineDefinitionSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final String code() {
        return this.code;
    }

    public final String message() {
        return this.message;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateStateMachineDefinitionDiagnostic)) {
            return false;
        }
        ValidateStateMachineDefinitionDiagnostic other = (ValidateStateMachineDefinitionDiagnostic)obj;
        return Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateStateMachineDefinitionDiagnostic").add("Severity", (Object)this.severityAsString()).add("Code", (Object)(this.code() == null ? null : "*** Sensitive Data Redacted ***")).add("Message", (Object)(this.message() == null ? null : "*** Sensitive Data Redacted ***")).add("Location", (Object)(this.location() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ValidateStateMachineDefinitionDiagnostic, T> g) {
        return obj -> g.apply((ValidateStateMachineDefinitionDiagnostic)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String severity;
        private String code;
        private String message;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateStateMachineDefinitionDiagnostic model) {
            this.severity(model.severity);
            this.code(model.code);
            this.message(model.message);
            this.location(model.location);
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ValidateStateMachineDefinitionSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public ValidateStateMachineDefinitionDiagnostic build() {
            return new ValidateStateMachineDefinitionDiagnostic(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidateStateMachineDefinitionDiagnostic> {
        public Builder severity(String var1);

        public Builder severity(ValidateStateMachineDefinitionSeverity var1);

        public Builder code(String var1);

        public Builder message(String var1);

        public Builder location(String var1);
    }
}

