/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStateMachineAliasResponse extends SfnResponse implements
        ToCopyableBuilder<CreateStateMachineAliasResponse.Builder, CreateStateMachineAliasResponse> {
    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineAliasArn").getter(getter(CreateStateMachineAliasResponse::stateMachineAliasArn))
            .setter(setter(Builder::stateMachineAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build())
            .build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(CreateStateMachineAliasResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_MACHINE_ALIAS_ARN_FIELD,
            CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stateMachineAliasArn;

    private final Instant creationDate;

    private CreateStateMachineAliasResponse(BuilderImpl builder) {
        super(builder);
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the created state machine alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the created state machine alias.
     */
    public final String stateMachineAliasArn() {
        return stateMachineAliasArn;
    }

    /**
     * <p>
     * The date the state machine alias was created.
     * </p>
     * 
     * @return The date the state machine alias was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStateMachineAliasResponse)) {
            return false;
        }
        CreateStateMachineAliasResponse other = (CreateStateMachineAliasResponse) obj;
        return Objects.equals(stateMachineAliasArn(), other.stateMachineAliasArn())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStateMachineAliasResponse").add("StateMachineAliasArn", stateMachineAliasArn())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineAliasArn":
            return Optional.ofNullable(clazz.cast(stateMachineAliasArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStateMachineAliasResponse, T> g) {
        return obj -> g.apply((CreateStateMachineAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStateMachineAliasResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the created state machine alias.
         * </p>
         * 
         * @param stateMachineAliasArn
         *        The Amazon Resource Name (ARN) that identifies the created state machine alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliasArn(String stateMachineAliasArn);

        /**
         * <p>
         * The date the state machine alias was created.
         * </p>
         * 
         * @param creationDate
         *        The date the state machine alias was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private String stateMachineAliasArn;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStateMachineAliasResponse model) {
            super(model);
            stateMachineAliasArn(model.stateMachineAliasArn);
            creationDate(model.creationDate);
        }

        public final String getStateMachineAliasArn() {
            return stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateStateMachineAliasResponse build() {
            return new CreateStateMachineAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
