/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionRequest extends SfnRequest implements
        ToCopyableBuilder<DescribeExecutionRequest.Builder, DescribeExecutionRequest> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(DescribeExecutionRequest::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> INCLUDED_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("includedData").getter(getter(DescribeExecutionRequest::includedDataAsString))
            .setter(setter(Builder::includedData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includedData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            INCLUDED_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionArn;

    private final String includedData;

    private DescribeExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.includedData = builder.includedData;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution to describe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution to describe.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     * permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
     * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includedData} will
     * return {@link IncludedData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includedDataAsString}.
     * </p>
     * 
     * @return If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     *         permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
     *         <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * @see IncludedData
     */
    public final IncludedData includedData() {
        return IncludedData.fromValue(includedData);
    }

    /**
     * <p>
     * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     * permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
     * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #includedData} will
     * return {@link IncludedData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #includedDataAsString}.
     * </p>
     * 
     * @return If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
     *         permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
     *         <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
     * @see IncludedData
     */
    public final String includedDataAsString() {
        return includedData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(includedDataAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionRequest)) {
            return false;
        }
        DescribeExecutionRequest other = (DescribeExecutionRequest) obj;
        return Objects.equals(executionArn(), other.executionArn())
                && Objects.equals(includedDataAsString(), other.includedDataAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionRequest").add("ExecutionArn", executionArn())
                .add("IncludedData", includedDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "includedData":
            return Optional.ofNullable(clazz.cast(includedDataAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("includedData", INCLUDED_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionRequest, T> g) {
        return obj -> g.apply((DescribeExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution to describe.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) of the execution to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
         * permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
         * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
         * </p>
         * 
         * @param includedData
         *        If your state machine definition is encrypted with a KMS key, callers must have
         *        <code>kms:Decrypt</code> permission to decrypt the definition. Alternatively, you can call
         *        DescribeStateMachine API with <code>includedData = METADATA_ONLY</code> to get a successful response
         *        without the encrypted definition.
         * @see IncludedData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludedData
         */
        Builder includedData(String includedData);

        /**
         * <p>
         * If your state machine definition is encrypted with a KMS key, callers must have <code>kms:Decrypt</code>
         * permission to decrypt the definition. Alternatively, you can call DescribeStateMachine API with
         * <code>includedData = METADATA_ONLY</code> to get a successful response without the encrypted definition.
         * </p>
         * 
         * @param includedData
         *        If your state machine definition is encrypted with a KMS key, callers must have
         *        <code>kms:Decrypt</code> permission to decrypt the definition. Alternatively, you can call
         *        DescribeStateMachine API with <code>includedData = METADATA_ONLY</code> to get a successful response
         *        without the encrypted definition.
         * @see IncludedData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludedData
         */
        Builder includedData(IncludedData includedData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SfnRequest.BuilderImpl implements Builder {
        private String executionArn;

        private String includedData;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionRequest model) {
            super(model);
            executionArn(model.executionArn);
            includedData(model.includedData);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getIncludedData() {
            return includedData;
        }

        public final void setIncludedData(String includedData) {
            this.includedData = includedData;
        }

        @Override
        public final Builder includedData(String includedData) {
            this.includedData = includedData;
            return this;
        }

        @Override
        public final Builder includedData(IncludedData includedData) {
            this.includedData(includedData == null ? null : includedData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeExecutionRequest build() {
            return new DescribeExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
