/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the start of the execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStartedEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionStartedEventDetails.Builder, ExecutionStartedEventDetails> {
    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(ExecutionStartedEventDetails::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> INPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("inputDetails")
            .getter(getter(ExecutionStartedEventDetails::inputDetails)).setter(setter(Builder::inputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDetails").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ExecutionStartedEventDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATE_MACHINE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineAliasArn").getter(getter(ExecutionStartedEventDetails::stateMachineAliasArn))
            .setter(setter(Builder::stateMachineAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineAliasArn").build())
            .build();

    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineVersionArn").getter(getter(ExecutionStartedEventDetails::stateMachineVersionArn))
            .setter(setter(Builder::stateMachineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            INPUT_DETAILS_FIELD, ROLE_ARN_FIELD, STATE_MACHINE_ALIAS_ARN_FIELD, STATE_MACHINE_VERSION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String input;

    private final HistoryEventExecutionDataDetails inputDetails;

    private final String roleArn;

    private final String stateMachineAliasArn;

    private final String stateMachineVersionArn;

    private ExecutionStartedEventDetails(BuilderImpl builder) {
        this.input = builder.input;
        this.inputDetails = builder.inputDetails;
        this.roleArn = builder.roleArn;
        this.stateMachineAliasArn = builder.stateMachineAliasArn;
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
    }

    /**
     * <p>
     * The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as bytes in
     * UTF-8 encoding.
     * </p>
     * 
     * @return The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * Contains details about the input for an execution history event.
     * </p>
     * 
     * @return Contains details about the input for an execution history event.
     */
    public final HistoryEventExecutionDataDetails inputDetails() {
        return inputDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role used for executing Lambda tasks.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role used for executing Lambda tasks.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine alias used for starting the state machine
     * execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a state machine alias used for starting the state machine
     *         execution.
     */
    public final String stateMachineAliasArn() {
        return stateMachineAliasArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version used for starting the state machine
     * execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a state machine version used for starting the state
     *         machine execution.
     */
    public final String stateMachineVersionArn() {
        return stateMachineVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(inputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStartedEventDetails)) {
            return false;
        }
        ExecutionStartedEventDetails other = (ExecutionStartedEventDetails) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(inputDetails(), other.inputDetails())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stateMachineAliasArn(), other.stateMachineAliasArn())
                && Objects.equals(stateMachineVersionArn(), other.stateMachineVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStartedEventDetails")
                .add("Input", input() == null ? null : "*** Sensitive Data Redacted ***").add("InputDetails", inputDetails())
                .add("RoleArn", roleArn()).add("StateMachineAliasArn", stateMachineAliasArn())
                .add("StateMachineVersionArn", stateMachineVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "inputDetails":
            return Optional.ofNullable(clazz.cast(inputDetails()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "stateMachineAliasArn":
            return Optional.ofNullable(clazz.cast(stateMachineAliasArn()));
        case "stateMachineVersionArn":
            return Optional.ofNullable(clazz.cast(stateMachineVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("input", INPUT_FIELD);
        map.put("inputDetails", INPUT_DETAILS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("stateMachineAliasArn", STATE_MACHINE_ALIAS_ARN_FIELD);
        map.put("stateMachineVersionArn", STATE_MACHINE_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStartedEventDetails, T> g) {
        return obj -> g.apply((ExecutionStartedEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStartedEventDetails> {
        /**
         * <p>
         * The JSON data input to the execution. Length constraints apply to the payload size, and are expressed as
         * bytes in UTF-8 encoding.
         * </p>
         * 
         * @param input
         *        The JSON data input to the execution. Length constraints apply to the payload size, and are expressed
         *        as bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * 
         * @param inputDetails
         *        Contains details about the input for an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDetails(HistoryEventExecutionDataDetails inputDetails);

        /**
         * <p>
         * Contains details about the input for an execution history event.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param inputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder inputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> inputDetails) {
            return inputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(inputDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role used for executing Lambda tasks.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role used for executing Lambda tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies a state machine alias used for starting the state machine
         * execution.
         * </p>
         * 
         * @param stateMachineAliasArn
         *        The Amazon Resource Name (ARN) that identifies a state machine alias used for starting the state
         *        machine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineAliasArn(String stateMachineAliasArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies a state machine version used for starting the state machine
         * execution.
         * </p>
         * 
         * @param stateMachineVersionArn
         *        The Amazon Resource Name (ARN) that identifies a state machine version used for starting the state
         *        machine execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineVersionArn(String stateMachineVersionArn);
    }

    static final class BuilderImpl implements Builder {
        private String input;

        private HistoryEventExecutionDataDetails inputDetails;

        private String roleArn;

        private String stateMachineAliasArn;

        private String stateMachineVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStartedEventDetails model) {
            input(model.input);
            inputDetails(model.inputDetails);
            roleArn(model.roleArn);
            stateMachineAliasArn(model.stateMachineAliasArn);
            stateMachineVersionArn(model.stateMachineVersionArn);
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final HistoryEventExecutionDataDetails.Builder getInputDetails() {
            return inputDetails != null ? inputDetails.toBuilder() : null;
        }

        public final void setInputDetails(HistoryEventExecutionDataDetails.BuilderImpl inputDetails) {
            this.inputDetails = inputDetails != null ? inputDetails.build() : null;
        }

        @Override
        public final Builder inputDetails(HistoryEventExecutionDataDetails inputDetails) {
            this.inputDetails = inputDetails;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStateMachineAliasArn() {
            return stateMachineAliasArn;
        }

        public final void setStateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
        }

        @Override
        public final Builder stateMachineAliasArn(String stateMachineAliasArn) {
            this.stateMachineAliasArn = stateMachineAliasArn;
            return this;
        }

        public final String getStateMachineVersionArn() {
            return stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        @Override
        public ExecutionStartedEventDetails build() {
            return new ExecutionStartedEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
