/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional details about the state's execution, including its input and output data processing flow, and
 * HTTP request and response information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectionData implements SdkPojo, Serializable, ToCopyableBuilder<InspectionData.Builder, InspectionData> {
    private static final SdkField<String> INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("input")
            .getter(getter(InspectionData::input)).setter(setter(Builder::input))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> AFTER_ARGUMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterArguments").getter(getter(InspectionData::afterArguments)).setter(setter(Builder::afterArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterArguments").build()).build();

    private static final SdkField<String> AFTER_INPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterInputPath").getter(getter(InspectionData::afterInputPath)).setter(setter(Builder::afterInputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterInputPath").build()).build();

    private static final SdkField<String> AFTER_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterParameters").getter(getter(InspectionData::afterParameters))
            .setter(setter(Builder::afterParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterParameters").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(InspectionData::result)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<String> AFTER_RESULT_SELECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterResultSelector").getter(getter(InspectionData::afterResultSelector))
            .setter(setter(Builder::afterResultSelector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultSelector").build())
            .build();

    private static final SdkField<String> AFTER_RESULT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterResultPath").getter(getter(InspectionData::afterResultPath))
            .setter(setter(Builder::afterResultPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterResultPath").build()).build();

    private static final SdkField<InspectionDataRequest> REQUEST_FIELD = SdkField
            .<InspectionDataRequest> builder(MarshallingType.SDK_POJO).memberName("request")
            .getter(getter(InspectionData::request)).setter(setter(Builder::request)).constructor(InspectionDataRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()).build();

    private static final SdkField<InspectionDataResponse> RESPONSE_FIELD = SdkField
            .<InspectionDataResponse> builder(MarshallingType.SDK_POJO).memberName("response")
            .getter(getter(InspectionData::response)).setter(setter(Builder::response))
            .constructor(InspectionDataResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()).build();

    private static final SdkField<String> VARIABLES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("variables").getter(getter(InspectionData::variables)).setter(setter(Builder::variables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            AFTER_ARGUMENTS_FIELD, AFTER_INPUT_PATH_FIELD, AFTER_PARAMETERS_FIELD, RESULT_FIELD, AFTER_RESULT_SELECTOR_FIELD,
            AFTER_RESULT_PATH_FIELD, REQUEST_FIELD, RESPONSE_FIELD, VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String input;

    private final String afterArguments;

    private final String afterInputPath;

    private final String afterParameters;

    private final String result;

    private final String afterResultSelector;

    private final String afterResultPath;

    private final InspectionDataRequest request;

    private final InspectionDataResponse response;

    private final String variables;

    private InspectionData(BuilderImpl builder) {
        this.input = builder.input;
        this.afterArguments = builder.afterArguments;
        this.afterInputPath = builder.afterInputPath;
        this.afterParameters = builder.afterParameters;
        this.result = builder.result;
        this.afterResultSelector = builder.afterResultSelector;
        this.afterResultPath = builder.afterResultPath;
        this.request = builder.request;
        this.response = builder.response;
        this.variables = builder.variables;
    }

    /**
     * <p>
     * The raw state input.
     * </p>
     * 
     * @return The raw state input.
     */
    public final String input() {
        return input;
    }

    /**
     * <p>
     * The input after Step Functions applies an Arguments filter. This event will only be present when QueryLanguage
     * for the state machine or individual states is set to JSONata. For more info, see <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/data-transform.html">Transforming data with Step
     * Functions</a>.
     * </p>
     * 
     * @return The input after Step Functions applies an Arguments filter. This event will only be present when
     *         QueryLanguage for the state machine or individual states is set to JSONata. For more info, see <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/data-transform.html">Transforming data with
     *         Step Functions</a>.
     */
    public final String afterArguments() {
        return afterArguments;
    }

    /**
     * <p>
     * The input after Step Functions applies the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath"
     * >InputPath</a> filter. Not populated when QueryLanguage is JSONata.
     * </p>
     * 
     * @return The input after Step Functions applies the <a href=
     *         "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath"
     *         >InputPath</a> filter. Not populated when QueryLanguage is JSONata.
     */
    public final String afterInputPath() {
        return afterInputPath;
    }

    /**
     * <p>
     * The effective input after Step Functions applies the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters"
     * >Parameters</a> filter. Not populated when QueryLanguage is JSONata.
     * </p>
     * 
     * @return The effective input after Step Functions applies the <a href=
     *         "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters"
     *         >Parameters</a> filter. Not populated when QueryLanguage is JSONata.
     */
    public final String afterParameters() {
        return afterParameters;
    }

    /**
     * <p>
     * The state's raw result.
     * </p>
     * 
     * @return The state's raw result.
     */
    public final String result() {
        return result;
    }

    /**
     * <p>
     * The effective result after Step Functions applies the <a href=
     * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector"
     * >ResultSelector</a> filter. Not populated when QueryLanguage is JSONata.
     * </p>
     * 
     * @return The effective result after Step Functions applies the <a href=
     *         "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector"
     *         >ResultSelector</a> filter. Not populated when QueryLanguage is JSONata.
     */
    public final String afterResultSelector() {
        return afterResultSelector;
    }

    /**
     * <p>
     * The effective result combined with the raw state input after Step Functions applies the <a
     * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html">ResultPath</a> filter.
     * Not populated when QueryLanguage is JSONata.
     * </p>
     * 
     * @return The effective result combined with the raw state input after Step Functions applies the <a
     *         href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html">ResultPath</a>
     *         filter. Not populated when QueryLanguage is JSONata.
     */
    public final String afterResultPath() {
        return afterResultPath;
    }

    /**
     * <p>
     * The raw HTTP request that is sent when you test an HTTP Task.
     * </p>
     * 
     * @return The raw HTTP request that is sent when you test an HTTP Task.
     */
    public final InspectionDataRequest request() {
        return request;
    }

    /**
     * <p>
     * The raw HTTP response that is returned when you test an HTTP Task.
     * </p>
     * 
     * @return The raw HTTP response that is returned when you test an HTTP Task.
     */
    public final InspectionDataResponse response() {
        return response;
    }

    /**
     * <p>
     * JSON string that contains the set of workflow variables after execution of the state. The set will include
     * variables assigned in the state and variables set up as test state input.
     * </p>
     * 
     * @return JSON string that contains the set of workflow variables after execution of the state. The set will
     *         include variables assigned in the state and variables set up as test state input.
     */
    public final String variables() {
        return variables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(afterArguments());
        hashCode = 31 * hashCode + Objects.hashCode(afterInputPath());
        hashCode = 31 * hashCode + Objects.hashCode(afterParameters());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(afterResultSelector());
        hashCode = 31 * hashCode + Objects.hashCode(afterResultPath());
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(response());
        hashCode = 31 * hashCode + Objects.hashCode(variables());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionData)) {
            return false;
        }
        InspectionData other = (InspectionData) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(afterArguments(), other.afterArguments())
                && Objects.equals(afterInputPath(), other.afterInputPath())
                && Objects.equals(afterParameters(), other.afterParameters()) && Objects.equals(result(), other.result())
                && Objects.equals(afterResultSelector(), other.afterResultSelector())
                && Objects.equals(afterResultPath(), other.afterResultPath()) && Objects.equals(request(), other.request())
                && Objects.equals(response(), other.response()) && Objects.equals(variables(), other.variables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InspectionData").add("Input", input() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AfterArguments", afterArguments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AfterInputPath", afterInputPath() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AfterParameters", afterParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Result", result() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AfterResultSelector", afterResultSelector() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AfterResultPath", afterResultPath() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Request", request()).add("Response", response())
                .add("Variables", variables() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "afterArguments":
            return Optional.ofNullable(clazz.cast(afterArguments()));
        case "afterInputPath":
            return Optional.ofNullable(clazz.cast(afterInputPath()));
        case "afterParameters":
            return Optional.ofNullable(clazz.cast(afterParameters()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "afterResultSelector":
            return Optional.ofNullable(clazz.cast(afterResultSelector()));
        case "afterResultPath":
            return Optional.ofNullable(clazz.cast(afterResultPath()));
        case "request":
            return Optional.ofNullable(clazz.cast(request()));
        case "response":
            return Optional.ofNullable(clazz.cast(response()));
        case "variables":
            return Optional.ofNullable(clazz.cast(variables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("input", INPUT_FIELD);
        map.put("afterArguments", AFTER_ARGUMENTS_FIELD);
        map.put("afterInputPath", AFTER_INPUT_PATH_FIELD);
        map.put("afterParameters", AFTER_PARAMETERS_FIELD);
        map.put("result", RESULT_FIELD);
        map.put("afterResultSelector", AFTER_RESULT_SELECTOR_FIELD);
        map.put("afterResultPath", AFTER_RESULT_PATH_FIELD);
        map.put("request", REQUEST_FIELD);
        map.put("response", RESPONSE_FIELD);
        map.put("variables", VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InspectionData, T> g) {
        return obj -> g.apply((InspectionData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectionData> {
        /**
         * <p>
         * The raw state input.
         * </p>
         * 
         * @param input
         *        The raw state input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(String input);

        /**
         * <p>
         * The input after Step Functions applies an Arguments filter. This event will only be present when
         * QueryLanguage for the state machine or individual states is set to JSONata. For more info, see <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/data-transform.html">Transforming data with Step
         * Functions</a>.
         * </p>
         * 
         * @param afterArguments
         *        The input after Step Functions applies an Arguments filter. This event will only be present when
         *        QueryLanguage for the state machine or individual states is set to JSONata. For more info, see <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/data-transform.html">Transforming data with
         *        Step Functions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterArguments(String afterArguments);

        /**
         * <p>
         * The input after Step Functions applies the <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath"
         * >InputPath</a> filter. Not populated when QueryLanguage is JSONata.
         * </p>
         * 
         * @param afterInputPath
         *        The input after Step Functions applies the <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-inputpath"
         *        >InputPath</a> filter. Not populated when QueryLanguage is JSONata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterInputPath(String afterInputPath);

        /**
         * <p>
         * The effective input after Step Functions applies the <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters"
         * >Parameters</a> filter. Not populated when QueryLanguage is JSONata.
         * </p>
         * 
         * @param afterParameters
         *        The effective input after Step Functions applies the <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters"
         *        >Parameters</a> filter. Not populated when QueryLanguage is JSONata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterParameters(String afterParameters);

        /**
         * <p>
         * The state's raw result.
         * </p>
         * 
         * @param result
         *        The state's raw result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(String result);

        /**
         * <p>
         * The effective result after Step Functions applies the <a href=
         * "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector"
         * >ResultSelector</a> filter. Not populated when QueryLanguage is JSONata.
         * </p>
         * 
         * @param afterResultSelector
         *        The effective result after Step Functions applies the <a href=
         *        "https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector"
         *        >ResultSelector</a> filter. Not populated when QueryLanguage is JSONata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterResultSelector(String afterResultSelector);

        /**
         * <p>
         * The effective result combined with the raw state input after Step Functions applies the <a
         * href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html">ResultPath</a>
         * filter. Not populated when QueryLanguage is JSONata.
         * </p>
         * 
         * @param afterResultPath
         *        The effective result combined with the raw state input after Step Functions applies the <a
         *        href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-resultpath.html"
         *        >ResultPath</a> filter. Not populated when QueryLanguage is JSONata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterResultPath(String afterResultPath);

        /**
         * <p>
         * The raw HTTP request that is sent when you test an HTTP Task.
         * </p>
         * 
         * @param request
         *        The raw HTTP request that is sent when you test an HTTP Task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(InspectionDataRequest request);

        /**
         * <p>
         * The raw HTTP request that is sent when you test an HTTP Task.
         * </p>
         * This is a convenience method that creates an instance of the {@link InspectionDataRequest.Builder} avoiding
         * the need to create one manually via {@link InspectionDataRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InspectionDataRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #request(InspectionDataRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link InspectionDataRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(InspectionDataRequest)
         */
        default Builder request(Consumer<InspectionDataRequest.Builder> request) {
            return request(InspectionDataRequest.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * The raw HTTP response that is returned when you test an HTTP Task.
         * </p>
         * 
         * @param response
         *        The raw HTTP response that is returned when you test an HTTP Task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(InspectionDataResponse response);

        /**
         * <p>
         * The raw HTTP response that is returned when you test an HTTP Task.
         * </p>
         * This is a convenience method that creates an instance of the {@link InspectionDataResponse.Builder} avoiding
         * the need to create one manually via {@link InspectionDataResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InspectionDataResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #response(InspectionDataResponse)}.
         * 
         * @param response
         *        a consumer that will call methods on {@link InspectionDataResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #response(InspectionDataResponse)
         */
        default Builder response(Consumer<InspectionDataResponse.Builder> response) {
            return response(InspectionDataResponse.builder().applyMutation(response).build());
        }

        /**
         * <p>
         * JSON string that contains the set of workflow variables after execution of the state. The set will include
         * variables assigned in the state and variables set up as test state input.
         * </p>
         * 
         * @param variables
         *        JSON string that contains the set of workflow variables after execution of the state. The set will
         *        include variables assigned in the state and variables set up as test state input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder variables(String variables);
    }

    static final class BuilderImpl implements Builder {
        private String input;

        private String afterArguments;

        private String afterInputPath;

        private String afterParameters;

        private String result;

        private String afterResultSelector;

        private String afterResultPath;

        private InspectionDataRequest request;

        private InspectionDataResponse response;

        private String variables;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionData model) {
            input(model.input);
            afterArguments(model.afterArguments);
            afterInputPath(model.afterInputPath);
            afterParameters(model.afterParameters);
            result(model.result);
            afterResultSelector(model.afterResultSelector);
            afterResultPath(model.afterResultPath);
            request(model.request);
            response(model.response);
            variables(model.variables);
        }

        public final String getInput() {
            return input;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final String getAfterArguments() {
            return afterArguments;
        }

        public final void setAfterArguments(String afterArguments) {
            this.afterArguments = afterArguments;
        }

        @Override
        public final Builder afterArguments(String afterArguments) {
            this.afterArguments = afterArguments;
            return this;
        }

        public final String getAfterInputPath() {
            return afterInputPath;
        }

        public final void setAfterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
        }

        @Override
        public final Builder afterInputPath(String afterInputPath) {
            this.afterInputPath = afterInputPath;
            return this;
        }

        public final String getAfterParameters() {
            return afterParameters;
        }

        public final void setAfterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
        }

        @Override
        public final Builder afterParameters(String afterParameters) {
            this.afterParameters = afterParameters;
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        public final String getAfterResultSelector() {
            return afterResultSelector;
        }

        public final void setAfterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
        }

        @Override
        public final Builder afterResultSelector(String afterResultSelector) {
            this.afterResultSelector = afterResultSelector;
            return this;
        }

        public final String getAfterResultPath() {
            return afterResultPath;
        }

        public final void setAfterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
        }

        @Override
        public final Builder afterResultPath(String afterResultPath) {
            this.afterResultPath = afterResultPath;
            return this;
        }

        public final InspectionDataRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(InspectionDataRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(InspectionDataRequest request) {
            this.request = request;
            return this;
        }

        public final InspectionDataResponse.Builder getResponse() {
            return response != null ? response.toBuilder() : null;
        }

        public final void setResponse(InspectionDataResponse.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(InspectionDataResponse response) {
            this.response = response;
            return this;
        }

        public final String getVariables() {
            return variables;
        }

        public final void setVariables(String variables) {
            this.variables = variables;
        }

        @Override
        public final Builder variables(String variables) {
            this.variables = variables;
            return this;
        }

        @Override
        public InspectionData build() {
            return new InspectionData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
