/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains additional details about the state's execution, including its input and output data processing flow, and
 * HTTP request information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InspectionDataRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<InspectionDataRequest.Builder, InspectionDataRequest> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(InspectionDataRequest::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("method")
            .getter(getter(InspectionDataRequest::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(InspectionDataRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> HEADERS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("headers")
            .getter(getter(InspectionDataRequest::headers)).setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(InspectionDataRequest::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, METHOD_FIELD,
            URL_FIELD, HEADERS_FIELD, BODY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String method;

    private final String url;

    private final String headers;

    private final String body;

    private InspectionDataRequest(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.method = builder.method;
        this.url = builder.url;
        this.headers = builder.headers;
        this.body = builder.body;
    }

    /**
     * <p>
     * The protocol used to make the HTTP request.
     * </p>
     * 
     * @return The protocol used to make the HTTP request.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The HTTP method used for the HTTP request.
     * </p>
     * 
     * @return The HTTP method used for the HTTP request.
     */
    public final String method() {
        return method;
    }

    /**
     * <p>
     * The API endpoint used for the HTTP request.
     * </p>
     * 
     * @return The API endpoint used for the HTTP request.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The request headers associated with the HTTP request.
     * </p>
     * 
     * @return The request headers associated with the HTTP request.
     */
    public final String headers() {
        return headers;
    }

    /**
     * <p>
     * The request body for the HTTP request.
     * </p>
     * 
     * @return The request body for the HTTP request.
     */
    public final String body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(headers());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InspectionDataRequest)) {
            return false;
        }
        InspectionDataRequest other = (InspectionDataRequest) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(method(), other.method())
                && Objects.equals(url(), other.url()) && Objects.equals(headers(), other.headers())
                && Objects.equals(body(), other.body());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InspectionDataRequest").add("Protocol", protocol()).add("Method", method()).add("Url", url())
                .add("Headers", headers()).add("Body", body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "method":
            return Optional.ofNullable(clazz.cast(method()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("protocol", PROTOCOL_FIELD);
        map.put("method", METHOD_FIELD);
        map.put("url", URL_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InspectionDataRequest, T> g) {
        return obj -> g.apply((InspectionDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InspectionDataRequest> {
        /**
         * <p>
         * The protocol used to make the HTTP request.
         * </p>
         * 
         * @param protocol
         *        The protocol used to make the HTTP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The HTTP method used for the HTTP request.
         * </p>
         * 
         * @param method
         *        The HTTP method used for the HTTP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);

        /**
         * <p>
         * The API endpoint used for the HTTP request.
         * </p>
         * 
         * @param url
         *        The API endpoint used for the HTTP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The request headers associated with the HTTP request.
         * </p>
         * 
         * @param headers
         *        The request headers associated with the HTTP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(String headers);

        /**
         * <p>
         * The request body for the HTTP request.
         * </p>
         * 
         * @param body
         *        The request body for the HTTP request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String method;

        private String url;

        private String headers;

        private String body;

        private BuilderImpl() {
        }

        private BuilderImpl(InspectionDataRequest model) {
            protocol(model.protocol);
            method(model.method);
            url(model.url);
            headers(model.headers);
            body(model.body);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getHeaders() {
            return headers;
        }

        public final void setHeaders(String headers) {
            this.headers = headers;
        }

        @Override
        public final Builder headers(String headers) {
            this.headers = headers;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public InspectionDataRequest build() {
            return new InspectionDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
