/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an exit from a state during an execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateExitedEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StateExitedEventDetails.Builder, StateExitedEventDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StateExitedEventDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(StateExitedEventDetails::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<HistoryEventExecutionDataDetails> OUTPUT_DETAILS_FIELD = SdkField
            .<HistoryEventExecutionDataDetails> builder(MarshallingType.SDK_POJO).memberName("outputDetails")
            .getter(getter(StateExitedEventDetails::outputDetails)).setter(setter(Builder::outputDetails))
            .constructor(HistoryEventExecutionDataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDetails").build()).build();

    private static final SdkField<Map<String, String>> ASSIGNED_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("assignedVariables")
            .getter(getter(StateExitedEventDetails::assignedVariables))
            .setter(setter(Builder::assignedVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AssignedVariablesDetails> ASSIGNED_VARIABLES_DETAILS_FIELD = SdkField
            .<AssignedVariablesDetails> builder(MarshallingType.SDK_POJO).memberName("assignedVariablesDetails")
            .getter(getter(StateExitedEventDetails::assignedVariablesDetails)).setter(setter(Builder::assignedVariablesDetails))
            .constructor(AssignedVariablesDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedVariablesDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OUTPUT_FIELD,
            OUTPUT_DETAILS_FIELD, ASSIGNED_VARIABLES_FIELD, ASSIGNED_VARIABLES_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String output;

    private final HistoryEventExecutionDataDetails outputDetails;

    private final Map<String, String> assignedVariables;

    private final AssignedVariablesDetails assignedVariablesDetails;

    private StateExitedEventDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.output = builder.output;
        this.outputDetails = builder.outputDetails;
        this.assignedVariables = builder.assignedVariables;
        this.assignedVariablesDetails = builder.assignedVariablesDetails;
    }

    /**
     * <p>
     * The name of the state.
     * </p>
     * <p>
     * A name must <i>not</i> contain:
     * </p>
     * <ul>
     * <li>
     * <p>
     * white space
     * </p>
     * </li>
     * <li>
     * <p>
     * brackets <code>&lt; &gt; { } [ ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * wildcard characters <code>? *</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     * </p>
     * </li>
     * </ul>
     * <p>
     * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     * </p>
     * 
     * @return The name of the state.</p>
     *         <p>
     *         A name must <i>not</i> contain:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         white space
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         brackets <code>&lt; &gt; { } [ ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         wildcard characters <code>? *</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes in
     * UTF-8 encoding.
     * </p>
     * 
     * @return The JSON output data of the state. Length constraints apply to the payload size, and are expressed as
     *         bytes in UTF-8 encoding.
     */
    public final String output() {
        return output;
    }

    /**
     * <p>
     * Contains details about the output of an execution history event.
     * </p>
     * 
     * @return Contains details about the output of an execution history event.
     */
    public final HistoryEventExecutionDataDetails outputDetails() {
        return outputDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssignedVariables() {
        return assignedVariables != null && !(assignedVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Map of variable name and value as a serialized JSON representation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedVariables} method.
     * </p>
     * 
     * @return Map of variable name and value as a serialized JSON representation.
     */
    public final Map<String, String> assignedVariables() {
        return assignedVariables;
    }

    /**
     * <p>
     * Provides details about input or output in an execution history event.
     * </p>
     * 
     * @return Provides details about input or output in an execution history event.
     */
    public final AssignedVariablesDetails assignedVariablesDetails() {
        return assignedVariablesDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(outputDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedVariables() ? assignedVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assignedVariablesDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateExitedEventDetails)) {
            return false;
        }
        StateExitedEventDetails other = (StateExitedEventDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(output(), other.output())
                && Objects.equals(outputDetails(), other.outputDetails())
                && hasAssignedVariables() == other.hasAssignedVariables()
                && Objects.equals(assignedVariables(), other.assignedVariables())
                && Objects.equals(assignedVariablesDetails(), other.assignedVariablesDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateExitedEventDetails").add("Name", name())
                .add("Output", output() == null ? null : "*** Sensitive Data Redacted ***").add("OutputDetails", outputDetails())
                .add("AssignedVariables", assignedVariables() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AssignedVariablesDetails", assignedVariablesDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "outputDetails":
            return Optional.ofNullable(clazz.cast(outputDetails()));
        case "assignedVariables":
            return Optional.ofNullable(clazz.cast(assignedVariables()));
        case "assignedVariablesDetails":
            return Optional.ofNullable(clazz.cast(assignedVariablesDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("outputDetails", OUTPUT_DETAILS_FIELD);
        map.put("assignedVariables", ASSIGNED_VARIABLES_FIELD);
        map.put("assignedVariablesDetails", ASSIGNED_VARIABLES_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateExitedEventDetails, T> g) {
        return obj -> g.apply((StateExitedEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateExitedEventDetails> {
        /**
         * <p>
         * The name of the state.
         * </p>
         * <p>
         * A name must <i>not</i> contain:
         * </p>
         * <ul>
         * <li>
         * <p>
         * white space
         * </p>
         * </li>
         * <li>
         * <p>
         * brackets <code>&lt; &gt; { } [ ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * wildcard characters <code>? *</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         * </p>
         * </li>
         * </ul>
         * <p>
         * To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * </p>
         * 
         * @param name
         *        The name of the state.</p>
         *        <p>
         *        A name must <i>not</i> contain:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        white space
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        brackets <code>&lt; &gt; { } [ ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        wildcard characters <code>? *</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        special characters <code>" # % \ ^ | ~ ` $ &amp; , ; : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        control characters (<code>U+0000-001F</code>, <code>U+007F-009F</code>)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The JSON output data of the state. Length constraints apply to the payload size, and are expressed as bytes
         * in UTF-8 encoding.
         * </p>
         * 
         * @param output
         *        The JSON output data of the state. Length constraints apply to the payload size, and are expressed as
         *        bytes in UTF-8 encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * <p>
         * Contains details about the output of an execution history event.
         * </p>
         * 
         * @param outputDetails
         *        Contains details about the output of an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDetails(HistoryEventExecutionDataDetails outputDetails);

        /**
         * <p>
         * Contains details about the output of an execution history event.
         * </p>
         * This is a convenience method that creates an instance of the {@link HistoryEventExecutionDataDetails.Builder}
         * avoiding the need to create one manually via {@link HistoryEventExecutionDataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HistoryEventExecutionDataDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #outputDetails(HistoryEventExecutionDataDetails)}.
         * 
         * @param outputDetails
         *        a consumer that will call methods on {@link HistoryEventExecutionDataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDetails(HistoryEventExecutionDataDetails)
         */
        default Builder outputDetails(Consumer<HistoryEventExecutionDataDetails.Builder> outputDetails) {
            return outputDetails(HistoryEventExecutionDataDetails.builder().applyMutation(outputDetails).build());
        }

        /**
         * <p>
         * Map of variable name and value as a serialized JSON representation.
         * </p>
         * 
         * @param assignedVariables
         *        Map of variable name and value as a serialized JSON representation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedVariables(Map<String, String> assignedVariables);

        /**
         * <p>
         * Provides details about input or output in an execution history event.
         * </p>
         * 
         * @param assignedVariablesDetails
         *        Provides details about input or output in an execution history event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedVariablesDetails(AssignedVariablesDetails assignedVariablesDetails);

        /**
         * <p>
         * Provides details about input or output in an execution history event.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssignedVariablesDetails.Builder}
         * avoiding the need to create one manually via {@link AssignedVariablesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignedVariablesDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #assignedVariablesDetails(AssignedVariablesDetails)}.
         * 
         * @param assignedVariablesDetails
         *        a consumer that will call methods on {@link AssignedVariablesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignedVariablesDetails(AssignedVariablesDetails)
         */
        default Builder assignedVariablesDetails(Consumer<AssignedVariablesDetails.Builder> assignedVariablesDetails) {
            return assignedVariablesDetails(AssignedVariablesDetails.builder().applyMutation(assignedVariablesDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String output;

        private HistoryEventExecutionDataDetails outputDetails;

        private Map<String, String> assignedVariables = DefaultSdkAutoConstructMap.getInstance();

        private AssignedVariablesDetails assignedVariablesDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StateExitedEventDetails model) {
            name(model.name);
            output(model.output);
            outputDetails(model.outputDetails);
            assignedVariables(model.assignedVariables);
            assignedVariablesDetails(model.assignedVariablesDetails);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final HistoryEventExecutionDataDetails.Builder getOutputDetails() {
            return outputDetails != null ? outputDetails.toBuilder() : null;
        }

        public final void setOutputDetails(HistoryEventExecutionDataDetails.BuilderImpl outputDetails) {
            this.outputDetails = outputDetails != null ? outputDetails.build() : null;
        }

        @Override
        public final Builder outputDetails(HistoryEventExecutionDataDetails outputDetails) {
            this.outputDetails = outputDetails;
            return this;
        }

        public final Map<String, String> getAssignedVariables() {
            if (assignedVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return assignedVariables;
        }

        public final void setAssignedVariables(Map<String, String> assignedVariables) {
            this.assignedVariables = AssignedVariablesCopier.copy(assignedVariables);
        }

        @Override
        public final Builder assignedVariables(Map<String, String> assignedVariables) {
            this.assignedVariables = AssignedVariablesCopier.copy(assignedVariables);
            return this;
        }

        public final AssignedVariablesDetails.Builder getAssignedVariablesDetails() {
            return assignedVariablesDetails != null ? assignedVariablesDetails.toBuilder() : null;
        }

        public final void setAssignedVariablesDetails(AssignedVariablesDetails.BuilderImpl assignedVariablesDetails) {
            this.assignedVariablesDetails = assignedVariablesDetails != null ? assignedVariablesDetails.build() : null;
        }

        @Override
        public final Builder assignedVariablesDetails(AssignedVariablesDetails assignedVariablesDetails) {
            this.assignedVariablesDetails = assignedVariablesDetails;
            return this;
        }

        @Override
        public StateExitedEventDetails build() {
            return new StateExitedEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
