/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStateMachineResponse extends SfnResponse implements
        ToCopyableBuilder<UpdateStateMachineResponse.Builder, UpdateStateMachineResponse> {
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateDate").getter(getter(UpdateStateMachineResponse::updateDate)).setter(setter(Builder::updateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateDate").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(UpdateStateMachineResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineVersionArn").getter(getter(UpdateStateMachineResponse::stateMachineVersionArn))
            .setter(setter(Builder::stateMachineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_DATE_FIELD,
            REVISION_ID_FIELD, STATE_MACHINE_VERSION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant updateDate;

    private final String revisionId;

    private final String stateMachineVersionArn;

    private UpdateStateMachineResponse(BuilderImpl builder) {
        super(builder);
        this.updateDate = builder.updateDate;
        this.revisionId = builder.revisionId;
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
    }

    /**
     * <p>
     * The date and time the state machine was updated.
     * </p>
     * 
     * @return The date and time the state machine was updated.
     */
    public final Instant updateDate() {
        return updateDate;
    }

    /**
     * <p>
     * The revision identifier for the updated state machine.
     * </p>
     * 
     * @return The revision identifier for the updated state machine.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the published state machine version.
     * </p>
     * <p>
     * If the <code>publish</code> parameter isn't set to <code>true</code>, this field returns null.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the published state machine version.</p>
     *         <p>
     *         If the <code>publish</code> parameter isn't set to <code>true</code>, this field returns null.
     */
    public final String stateMachineVersionArn() {
        return stateMachineVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateMachineResponse)) {
            return false;
        }
        UpdateStateMachineResponse other = (UpdateStateMachineResponse) obj;
        return Objects.equals(updateDate(), other.updateDate()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(stateMachineVersionArn(), other.stateMachineVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStateMachineResponse").add("UpdateDate", updateDate()).add("RevisionId", revisionId())
                .add("StateMachineVersionArn", stateMachineVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateDate":
            return Optional.ofNullable(clazz.cast(updateDate()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "stateMachineVersionArn":
            return Optional.ofNullable(clazz.cast(stateMachineVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("updateDate", UPDATE_DATE_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("stateMachineVersionArn", STATE_MACHINE_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateMachineResponse, T> g) {
        return obj -> g.apply((UpdateStateMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SfnResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStateMachineResponse> {
        /**
         * <p>
         * The date and time the state machine was updated.
         * </p>
         * 
         * @param updateDate
         *        The date and time the state machine was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);

        /**
         * <p>
         * The revision identifier for the updated state machine.
         * </p>
         * 
         * @param revisionId
         *        The revision identifier for the updated state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the published state machine version.
         * </p>
         * <p>
         * If the <code>publish</code> parameter isn't set to <code>true</code>, this field returns null.
         * </p>
         * 
         * @param stateMachineVersionArn
         *        The Amazon Resource Name (ARN) of the published state machine version.</p>
         *        <p>
         *        If the <code>publish</code> parameter isn't set to <code>true</code>, this field returns null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineVersionArn(String stateMachineVersionArn);
    }

    static final class BuilderImpl extends SfnResponse.BuilderImpl implements Builder {
        private Instant updateDate;

        private String revisionId;

        private String stateMachineVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateMachineResponse model) {
            super(model);
            updateDate(model.updateDate);
            revisionId(model.revisionId);
            stateMachineVersionArn(model.stateMachineVersionArn);
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getStateMachineVersionArn() {
            return stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        @Override
        public UpdateStateMachineResponse build() {
            return new UpdateStateMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
