/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.shield.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AttackPropertyIdentifier {
    DESTINATION_URL("DESTINATION_URL"),
    REFERRER("REFERRER"),
    SOURCE_ASN("SOURCE_ASN"),
    SOURCE_COUNTRY("SOURCE_COUNTRY"),
    SOURCE_IP_ADDRESS("SOURCE_IP_ADDRESS"),
    SOURCE_USER_AGENT("SOURCE_USER_AGENT"),
    WORDPRESS_PINGBACK_REFLECTOR("WORDPRESS_PINGBACK_REFLECTOR"),
    WORDPRESS_PINGBACK_SOURCE("WORDPRESS_PINGBACK_SOURCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AttackPropertyIdentifier> VALUE_MAP;
    private final String value;

    private AttackPropertyIdentifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttackPropertyIdentifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttackPropertyIdentifier> knownValues() {
        EnumSet<AttackPropertyIdentifier> knownValues = EnumSet.allOf(AttackPropertyIdentifier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AttackPropertyIdentifier.class, AttackPropertyIdentifier::toString);
    }
}

